/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon;

import com.sshtools.common.configuration.XmlConfigurationContext;
import com.sshtools.daemon.SshServer;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.configuration.XmlServerConfigurationContext;
import com.sshtools.daemon.forwarding.ForwardingServer;
import com.sshtools.daemon.session.SessionChannelFactory;
import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshDaemon {
    private static Log log = LogFactory.getLog((Class)SshDaemon.class);

    public static void main(String[] stringArray) {
        try {
            XmlServerConfigurationContext xmlServerConfigurationContext = new XmlServerConfigurationContext();
            xmlServerConfigurationContext.setServerConfigurationResource(ConfigurationLoader.checkAndGetProperty((String)"sshtools.server", (String)"server.xml"));
            xmlServerConfigurationContext.setPlatformConfigurationResource(System.getProperty("sshtools.platform", "platform.xml"));
            ConfigurationLoader.initialize((boolean)false, (ConfigurationContext)xmlServerConfigurationContext);
            XmlConfigurationContext xmlConfigurationContext = new XmlConfigurationContext();
            xmlConfigurationContext.setFailOnError(false);
            xmlConfigurationContext.setAPIConfigurationResource(ConfigurationLoader.checkAndGetProperty((String)"sshtools.config", (String)"sshtools.xml"));
            xmlConfigurationContext.setAutomationConfigurationResource(ConfigurationLoader.checkAndGetProperty((String)"sshtools.automate", (String)"automation.xml"));
            ConfigurationLoader.initialize((boolean)false, (ConfigurationContext)xmlConfigurationContext);
            if (stringArray.length > 0) {
                if (stringArray[0].equals("-start")) {
                    SshDaemon.start();
                } else if (stringArray[0].equals("-stop")) {
                    if (stringArray.length > 1) {
                        SshDaemon.stop(stringArray[1]);
                    } else {
                        SshDaemon.stop("The framework daemon is shutting down");
                    }
                } else {
                    System.out.println("Usage: SshDaemon [-start|-stop]");
                }
            } else {
                System.out.println("Usage: SshDaemon [-start|-stop]");
            }
        }
        catch (Exception exception) {
            log.error((Object)("The server failed to process the " + (stringArray.length > 0 ? stringArray[0] : "") + " command"), (Throwable)exception);
        }
    }

    public static void start() throws IOException {
        SshServer sshServer = new SshServer(){

            public void configureServices(ConnectionProtocol connectionProtocol) throws IOException {
                connectionProtocol.addChannelFactory("session", (ChannelFactory)new SessionChannelFactory());
                if (ConfigurationLoader.isConfigurationAvailable((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshDaemon.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration)) && ((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshDaemon.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))).getAllowTcpForwarding()) {
                    ForwardingServer forwardingServer = new ForwardingServer(connectionProtocol);
                }
            }

            public void shutdown(String string) {
            }
        };
        sshServer.startServer();
    }

    public static void stop(String string) throws IOException {
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), ((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)ServerConfiguration.class)).getCommandPort());
            socket.getOutputStream().write(58);
            int n = string.length() <= 255 ? string.length() : 255;
            socket.getOutputStream().write(n);
            if (n > 0) {
                socket.getOutputStream().write(string.substring(0, n).getBytes());
            }
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

