/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.configuration;

import com.sshtools.daemon.vfs.VFSMount;
import com.sshtools.daemon.vfs.VFSPermission;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformConfiguration
extends DefaultHandler {
    private static Log log = LogFactory.getLog((Class)PlatformConfiguration.class);
    private static final String PLATFORM_ELEMENT = "PlatformConfiguration";
    private static final String NATIVE_PROCESS_ELEMENT = "NativeProcessProvider";
    private static final String NATIVE_AUTH_ELEMENT = "NativeAuthenticationProvider";
    private static final String NFS_ELEMENT = "NativeFileSystemProvider";
    private static final String NATIVE_SETTING_ELEMENT = "NativeSetting";
    private static final String VFSMOUNT_ELEMENT = "VFSMount";
    private static final String VFSROOT_ELEMENT = "VFSRoot";
    private static final String VFSPERMISSION_ELEMENT = "VFSPermission";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String MOUNT_ATTRIBUTE = "mount";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String PERMISSIONS_ATTRIBUTE = "permissions";
    private String currentElement = null;
    private Map nativeSettings = new HashMap();
    private String nativeProcessProvider = null;
    private String nativeAuthenticationProvider = null;
    private String nativeFileSystemProvider = null;
    private Map vfsMounts = new HashMap();
    private VFSMount vfsRoot = null;

    protected PlatformConfiguration(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        this.reload(inputStream);
    }

    public void reload(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)new PlatformConfigurationSAXHandler());
    }

    public Map getVFSMounts() {
        return this.vfsMounts;
    }

    public String getNativeAuthenticationProvider() {
        return this.nativeAuthenticationProvider;
    }

    public String getNativeFileSystemProvider() {
        return this.nativeFileSystemProvider;
    }

    public String getNativeProcessProvider() {
        return this.nativeProcessProvider;
    }

    public String getSetting(String string) {
        return (String)this.nativeSettings.get(string);
    }

    public String getSetting(String string, String string2) {
        if (this.nativeSettings.containsKey(string)) {
            return (String)this.nativeSettings.get(string);
        }
        return string2;
    }

    public boolean containsSetting(String string) {
        return this.nativeSettings.containsKey(string);
    }

    public VFSMount getVFSRoot() {
        return this.vfsRoot;
    }

    public String toString() {
        Map.Entry entry;
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = string + "<!-- Platform Configuration file, Determines the behaviour of platform specific services -->\n<PlatformConfiguration>\n";
        string = string + "   <!-- The process provider for executing and redirecting a process -->\n";
        string = string + "   <NativeProcessProvider>" + this.nativeProcessProvider + "</" + NATIVE_PROCESS_ELEMENT + ">\n";
        string = string + "   <!-- The authentication provider for authenticating users and obtaining user information -->\n";
        string = string + "   <NativeAuthenticationProvider>" + this.nativeAuthenticationProvider + "</" + NATIVE_AUTH_ELEMENT + ">\n";
        string = string + "   <!-- Native settings which may be used by the process or authentication provider -->\n";
        Iterator iterator = this.nativeSettings.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = string + "   <NativeSetting name=\"" + entry.getKey().toString() + "\" " + VALUE_ATTRIBUTE + "=\"" + entry.getValue().toString() + "\"/>\n";
        }
        if (this.vfsRoot != null) {
            string = string + "   <VFSRoot path=\"" + this.vfsRoot + "\"/>\n";
        }
        iterator = this.vfsMounts.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String string2 = (String)entry.getValue();
            String string3 = (String)entry.getKey();
            string = string + "   <VFSMount " + (string3.equals(string2) ? "" : "mount=\"" + entry.getKey().toString() + "\" ") + PATH_ATTRIBUTE + "=\"" + entry.getValue().toString() + "\"/>\n";
        }
        string = string + "</PlatformConfiguration>";
        return string;
    }

    class PlatformConfigurationSAXHandler
    extends DefaultHandler {
        private VFSMount currentMount = null;

        PlatformConfigurationSAXHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5;
            if (PlatformConfiguration.this.currentElement == null) {
                if (string3.equals(PlatformConfiguration.PLATFORM_ELEMENT)) {
                    PlatformConfiguration.this.currentElement = string3;
                }
                PlatformConfiguration.this.nativeProcessProvider = null;
                PlatformConfiguration.this.nativeAuthenticationProvider = null;
                PlatformConfiguration.this.nativeSettings.clear();
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.PLATFORM_ELEMENT)) {
                if (!(string3.equals(PlatformConfiguration.NATIVE_PROCESS_ELEMENT) || string3.equals(PlatformConfiguration.NATIVE_AUTH_ELEMENT) || string3.equals(PlatformConfiguration.NATIVE_SETTING_ELEMENT) || string3.equals(PlatformConfiguration.VFSMOUNT_ELEMENT) || string3.equals(PlatformConfiguration.VFSROOT_ELEMENT) || string3.equals(PlatformConfiguration.NFS_ELEMENT))) {
                    throw new SAXException("Unexpected element " + string3);
                }
            } else {
                if (!PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSMOUNT_ELEMENT)) throw new SAXException("Unexpected element " + string3);
                if (!string3.equals(PlatformConfiguration.VFSPERMISSION_ELEMENT)) {
                    throw new SAXException("Unexpected element " + string3);
                }
            }
            PlatformConfiguration.this.currentElement = string3;
            if (string3.equals(PlatformConfiguration.NATIVE_SETTING_ELEMENT)) {
                string5 = attributes.getValue(PlatformConfiguration.NAME_ATTRIBUTE);
                string4 = attributes.getValue(PlatformConfiguration.VALUE_ATTRIBUTE);
                if (string5 == null || string4 == null) {
                    throw new SAXException("Required attributes missing for NativeSetting element");
                }
                log.debug((Object)("NativeSetting " + string5 + "=" + string4));
                PlatformConfiguration.this.nativeSettings.put(string5, string4);
            }
            if (string3.equals(PlatformConfiguration.VFSPERMISSION_ELEMENT)) {
                string5 = attributes.getValue(PlatformConfiguration.NAME_ATTRIBUTE);
                string4 = attributes.getValue(PlatformConfiguration.PERMISSIONS_ATTRIBUTE);
                this.currentMount.setPermissions(new VFSPermission(string5, string4));
            }
            if (string3.equals(PlatformConfiguration.VFSMOUNT_ELEMENT)) {
                string5 = attributes.getValue(PlatformConfiguration.PATH_ATTRIBUTE);
                string4 = attributes.getValue(PlatformConfiguration.MOUNT_ATTRIBUTE);
                String string6 = attributes.getValue(PlatformConfiguration.PERMISSIONS_ATTRIBUTE);
                if (string5 == null || string4 == null) throw new SAXException("Required path attribute for element <VFSMount> is missing");
                if (string4.trim().equals("/")) throw new SAXException("The root mount / cannot be configured, use <VFSRoot path=\"" + string5 + "\"/> instead");
                try {
                    this.currentMount = new VFSMount(string4, string5);
                    if (string6 == null) {
                        this.currentMount.setPermissions(new VFSPermission("default"));
                    } else {
                        this.currentMount.setPermissions(new VFSPermission("default", string6));
                    }
                    if (PlatformConfiguration.this.vfsMounts.containsKey(this.currentMount.getMount())) {
                        throw new SAXException("The mount " + string4 + " is already defined");
                    }
                    PlatformConfiguration.this.vfsMounts.put(this.currentMount.getMount(), this.currentMount);
                }
                catch (IOException iOException) {
                    throw new SAXException("VFSMount element is invalid mount=" + string4 + " path=" + string5);
                }
            }
            if (!string3.equals(PlatformConfiguration.VFSROOT_ELEMENT)) return;
            if (PlatformConfiguration.this.vfsRoot != null) {
                throw new SAXException("Only one VFSRoot can be defined");
            }
            string5 = attributes.getValue(PlatformConfiguration.PATH_ATTRIBUTE);
            string4 = attributes.getValue(PlatformConfiguration.PERMISSIONS_ATTRIBUTE);
            try {
                PlatformConfiguration.this.vfsRoot = new VFSMount("/", string5);
                if (string4 != null) {
                    PlatformConfiguration.this.vfsRoot.setPermissions(new VFSPermission("default", string4));
                } else {
                    PlatformConfiguration.this.vfsRoot.setPermissions(new VFSPermission("default"));
                }
                PlatformConfiguration.this.vfsRoot.setRoot(true);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException("VFSRoot element is invalid path=" + string5);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (PlatformConfiguration.this.currentElement == null) {
                throw new SAXException("Unexpected characters found");
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_AUTH_ELEMENT)) {
                PlatformConfiguration.this.nativeAuthenticationProvider = new String(cArray, n, n2).trim();
                log.debug((Object)("NativeAuthenticationProvider=" + PlatformConfiguration.this.nativeAuthenticationProvider));
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_PROCESS_ELEMENT)) {
                PlatformConfiguration.this.nativeProcessProvider = new String(cArray, n, n2).trim();
                log.debug((Object)("NativeProcessProvider=" + PlatformConfiguration.this.nativeProcessProvider));
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NFS_ELEMENT)) {
                PlatformConfiguration.this.nativeFileSystemProvider = new String(cArray, n, n2).trim();
                log.debug((Object)("NativeFileSystemProvider=" + PlatformConfiguration.this.nativeFileSystemProvider));
                return;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (PlatformConfiguration.this.currentElement == null) {
                throw new SAXException("Unexpected end element for " + string3);
            }
            if (!PlatformConfiguration.this.currentElement.equals(string3)) {
                throw new SAXException("Unexpected end element found");
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.PLATFORM_ELEMENT)) {
                PlatformConfiguration.this.currentElement = null;
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSPERMISSION_ELEMENT)) {
                PlatformConfiguration.this.currentElement = PlatformConfiguration.VFSMOUNT_ELEMENT;
            } else {
                if (!(PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_SETTING_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_AUTH_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_PROCESS_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NFS_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSMOUNT_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSROOT_ELEMENT))) {
                    throw new SAXException("Unexpected end element for " + string3);
                }
                PlatformConfiguration.this.currentElement = PlatformConfiguration.PLATFORM_ELEMENT;
            }
        }
    }
}

