/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml;

import de.berlios.statcvs.xml.InvalidCommandLineException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;

public class CommandLineParser {
    private String[] argsArray;
    private List args = new ArrayList();
    private int argCount = 0;

    public CommandLineParser(String[] args) {
        this.argsArray = args;
    }

    public void parse(Hashtable settings) throws InvalidCommandLineException {
        int i = 0;
        while (i < this.argsArray.length) {
            this.args.add(this.argsArray[i]);
            ++i;
        }
        while (!this.args.isEmpty()) {
            String currentArg = this.popNextArg();
            if (currentArg.startsWith("-")) {
                this.parseSwitch(settings, currentArg.substring(1));
                continue;
            }
            this.parseArgument(settings, currentArg);
        }
    }

    private String popNextArg() {
        return (String)this.args.remove(0);
    }

    private void parseSwitch(Hashtable settings, String switchName) throws InvalidCommandLineException {
        String s = switchName.toLowerCase();
        if (s.equals("output-dir")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -output-dir");
            }
            settings.put("outputDir", this.popNextArg());
        } else if (s.equals("renderer")) {
            settings.put("renderer", this.popNextArg());
        } else if (s.equals("suite")) {
            settings.put("suite", this.popNextArg());
        } else if (s.equals("verbose")) {
            settings.put("_logLevel", Level.INFO);
        } else if (s.equals("debug")) {
            settings.put("_logLevel", Level.FINEST);
        } else if (s.equals("weburl")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -weburl");
            }
            settings.put("webRepository", this.popNextArg());
        } else if (s.equals("viewcvs")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -viewcvs");
            }
            settings.put("viewcvs", this.popNextArg());
        } else if (s.equals("cvsweb")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -cvsweb");
            }
            settings.put("cvsweb", this.popNextArg());
        } else if (s.equals("chora")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -chora");
            }
            settings.put("chora", this.popNextArg());
        } else if (s.equals("include")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -include");
            }
            settings.put("include", this.popNextArg());
        } else if (s.equals("exclude")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -exclude");
            }
            settings.put("exclude", this.popNextArg());
        } else if (s.equals("title")) {
            if (this.args.isEmpty()) {
                throw new InvalidCommandLineException("Missing argument for -title");
            }
            settings.put("projectName", this.popNextArg());
        } else {
            throw new InvalidCommandLineException("Unrecognized option -" + s);
        }
    }

    private void parseArgument(Hashtable settings, String arg) throws InvalidCommandLineException {
        ++this.argCount;
        switch (this.argCount) {
            case 1: {
                settings.put("logFile", arg);
                break;
            }
            case 2: {
                settings.put("localRepository", arg);
                break;
            }
            default: {
                throw new InvalidCommandLineException("Too many arguments");
            }
        }
    }

    private void checkForRequiredArgs() throws InvalidCommandLineException {
        switch (this.argCount) {
            case 0: {
                throw new InvalidCommandLineException("Not enough arguments - <logfile> is missing");
            }
            case 1: {
                throw new InvalidCommandLineException("Not enough arguments - <directory> is missing");
            }
        }
    }
}

