/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml;

import de.berlios.statcvs.xml.CommandLineParser;
import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.InvalidCommandLineException;
import de.berlios.statcvs.xml.output.CSVOutputter;
import de.berlios.statcvs.xml.output.DocumentRenderer;
import de.berlios.statcvs.xml.output.DocumentSuite;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.util.FileHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.statcvs.input.Builder;
import net.sf.statcvs.input.CvsLogfileParser;
import net.sf.statcvs.input.EmptyRepositoryException;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.input.RepositoryFileManager;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.util.FilePatternMatcher;
import net.sf.statcvs.util.LogFormatter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Main {
    private static Logger logger = Logger.getLogger("de.berlios.statcvs.xml.Main");
    public static final String VERSION = "0.9.4";
    static /* synthetic */ Class class$net$sf$statcvs$model$CvsContent;
    static /* synthetic */ Class class$de$berlios$statcvs$xml$output$ReportSettings;

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        System.out.println(I18n.tr("StatCvs-XML {0} - CVS statistics generation", VERSION));
        System.out.println();
        if (args.length == 1) {
            String arg = args[0].toLowerCase();
            if (arg.equals("-h") || arg.equals("-help")) {
                Main.printProperUsageAndExit();
            } else if (arg.equals("-version")) {
                Main.printVersionAndExit();
            }
        }
        try {
            long startTime = System.currentTimeMillis();
            ReportSettings settings = Main.readSettings(args);
            CvsContent content = Main.generateContent(settings);
            Main.generateSuite(settings, content);
            long endTime = System.currentTimeMillis();
            System.out.println(I18n.tr("Done ({0}s). Generated reports in {1}.", new Long((endTime - startTime) / 1000L), settings.getOutputPath()));
        }
        catch (InvalidCommandLineException e) {
            System.err.println(e.getMessage());
            Main.printProperUsageAndExit();
        }
        catch (IOException e) {
            Main.printErrorMessageAndExit(e.getMessage());
        }
        catch (EmptyRepositoryException e) {
            Main.printErrorMessageAndExit(I18n.tr("Cowardly refusing to generate reports for an empty log"));
        }
        catch (LogSyntaxException lex) {
            Main.printLogErrorMessageAndExit(lex.getMessage());
        }
        catch (OutOfMemoryError oome) {
            Main.printOutOfMemMessageAndExit();
        }
        catch (Exception ioex) {
            ioex.printStackTrace();
            Main.printErrorMessageAndExit(ioex.getMessage());
        }
        System.exit(0);
    }

    private static void printProperUsageAndExit() {
        System.out.println("Usage: java -jar statcvs-xml-0.9.4-full.jar [options] [logfile [directory]]\n\nOptional parameters:\n  <logfile>          path to the cvs logfile of the module (default: cvs.log)\n  <directory>        path to the working directory (default: current directory)\n\nSome options:\n  -version           print the version information and exit\n  -output-dir <dir>  directory where HTML suite will be saved\n  -include <pattern> include only files matching pattern, e.g. **/*.c;**/*.h\n  -exclude <pattern> exclude matching files, e.g. tests/**;docs/**\n  -title <title>     Project title to be used in reports\n  -renderer <class>  class can be either html, xdoc, xml or a Java class name\n  -suite <file>      xml file that is used to generate the documents\n  -weburl <url>      integrate with web repository installation at <url>\n  -verbose           print extra progress information\n  -debug             print debug information\n\nIf statcvs cannot recognize the type of your web repository, please use the\nfollowing switches:\n  -viewcvs <url>     integrate with viewcvs installation at <url>\n  -cvsweb <url>      integrate with cvsweb installation at <url>\n  -chora <url>       integrate with chora installation at <url>\n\n");
        System.exit(1);
    }

    private static void printVersionAndExit() {
        System.out.println("Version 0.9.4");
        System.exit(1);
    }

    private static void printOutOfMemMessageAndExit() {
        System.err.println("OutOfMemoryError.");
        System.err.println("Try running java with the -mx option (e.g. -mx128m for 128Mb).");
        System.exit(1);
    }

    private static void printLogErrorMessageAndExit(String message) {
        System.err.println("Logfile parsing failed.");
        System.err.println(message);
        System.exit(1);
    }

    private static void printErrorMessageAndExit(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static ReportSettings readSettings(String[] args) throws IOException, InvalidCommandLineException {
        Hashtable cmdlSettings = new Hashtable();
        CommandLineParser parser = new CommandLineParser(args);
        parser.parse(cmdlSettings);
        Main.initLogger((Level)cmdlSettings.get("_logLevel"));
        ReportSettings settings = new ReportSettings(cmdlSettings);
        File file = new File("statcvs.xml");
        if (file.exists()) {
            try {
                logger.info(I18n.tr("Reading settings from {0}", file.getName()));
                SAXBuilder builder = new SAXBuilder();
                Document suite = builder.build(file);
                Element element = suite.getRootElement().getChild("settings");
                if (element != null) {
                    settings.load(element);
                }
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
        }
        return settings;
    }

    public static void initLogger(Level level) {
        if (level == null) {
            level = Level.WARNING;
        }
        ConsoleHandler ch = new ConsoleHandler();
        ch.setFormatter(new LogFormatter());
        ch.setLevel(level);
        Logger.getLogger("net.sf.statcvs").addHandler(ch);
        Logger.getLogger("net.sf.statcvs").setUseParentHandlers(false);
        Logger.getLogger("de.berlios.statcvs.xml").addHandler(ch);
        Logger.getLogger("de.berlios.statcvs.xml").setUseParentHandlers(false);
    }

    public static CvsContent generateContent(ReportSettings settings) throws IOException, LogSyntaxException, EmptyRepositoryException {
        String logFilename;
        FilePatternMatcher includeMatcher = null;
        if (settings.getString("include") != null) {
            includeMatcher = new FilePatternMatcher(settings.getString("include"));
        }
        FilePatternMatcher excludeMatcher = null;
        if (settings.getString("exclude") != null) {
            excludeMatcher = new FilePatternMatcher(settings.getString("exclude"));
        }
        if (!new File(logFilename = settings.getString("logFile", "cvs.log")).exists()) {
            throw new IOException(I18n.tr("CVS log file {0} not found, please run ''cvs log > {0}''", logFilename));
        }
        FileReader logReader = new FileReader(logFilename);
        logger.info("Parsing CVS log '" + logFilename + "'");
        RepositoryFileManager repFileMan = new RepositoryFileManager(settings.getString("localRepository", "."));
        Builder builder = new Builder(repFileMan, includeMatcher, excludeMatcher);
        if (builder.getProjectName() != null) {
            settings.put("projectName", builder.getProjectName());
        }
        new CvsLogfileParser(logReader, builder).parse();
        return builder.createCvsContent();
    }

    public static void generateSuite(ReportSettings settings, CvsContent content) throws IOException {
        DocumentRenderer renderer;
        File outDir = settings.getOutputPath();
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException(I18n.tr("Could not create output directory: {0}", outDir.getAbsolutePath()));
        }
        logger.info("Generating report for " + settings.getProjectName() + " into " + outDir.getAbsolutePath());
        if (settings.getWebRepository() != null) {
            logger.info("Assuming web repository is " + settings.getWebRepository().getName());
        }
        if ("csv".equals(settings.getString("suite"))) {
            File outFile = new File(outDir, settings.getProjectName() + "-loc.csv");
            logger.info("Creating CSV file " + outFile.getAbsolutePath());
            CSVOutputter.generate(settings, content, outFile);
            return;
        }
        String rendererClassname = settings.getRendererClassname();
        logger.info("Creating suite using " + rendererClassname);
        try {
            Class<?> c = Class.forName(rendererClassname);
            Method m = c.getMethod("create", class$net$sf$statcvs$model$CvsContent == null ? (class$net$sf$statcvs$model$CvsContent = Main.class$("net.sf.statcvs.model.CvsContent")) : class$net$sf$statcvs$model$CvsContent, class$de$berlios$statcvs$xml$output$ReportSettings == null ? (class$de$berlios$statcvs$xml$output$ReportSettings = Main.class$("de.berlios.statcvs.xml.output.ReportSettings")) : class$de$berlios$statcvs$xml$output$ReportSettings);
            renderer = (DocumentRenderer)m.invoke(null, content, settings);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(I18n.tr("Could not create renderer: {0}", e.getLocalizedMessage()));
        }
        URL suiteURL = FileHelper.getResource(settings.getString("suite", "resources/suite.xml"));
        DocumentSuite suite = new DocumentSuite(suiteURL, content);
        suite.generate(renderer, settings);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

