/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.chart;

import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.util.StringHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;

public abstract class AbstractChart {
    private static final Logger logger = Logger.getLogger("net.sf.statcvs.output.xml.chart.Chart");
    private static int chartNumber = 0;
    private String filename;
    private String subtitle;
    private JFreeChart chart;
    private ReportSettings settings;

    public AbstractChart(ReportSettings settings, String defaultFilename, String defaultSubtitle) {
        this.settings = settings;
        this.setFilename(settings.getString("filename", defaultFilename == null ? "chart" + ++chartNumber + ".png" : defaultFilename), settings.getFilenameId());
        this.setSubtitle(settings.getString("subtitle", defaultSubtitle), settings.getSubtitlePostfix());
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = StringHelper.escapeFilename(filename);
    }

    public void setFilename(String filename, String subst) {
        this.setFilename(filename.replaceAll("%1", subst));
    }

    public int getPreferredHeigth() {
        return 480;
    }

    public int getPreferredWidth() {
        return 640;
    }

    protected void setup(boolean defaultShowLegend) {
        Font font;
        if (this.chart == null) {
            throw new NullPointerException("Chart is not initialized");
        }
        if (this.subtitle != null && this.settings.getBoolean("showSubtitle", true)) {
            font = new Font("SansSerif", 0, 12);
            TextTitle title = new TextTitle(this.subtitle, font);
            title.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.0));
            this.chart.addSubtitle((Title)title);
        }
        if (this.settings.getBoolean("showCredit", true)) {
            font = new Font("SansSerif", 0, 9);
            TextTitle copyright = new TextTitle("generated by statcvs-xml\u00b2", font);
            copyright.setPosition(RectangleEdge.BOTTOM);
            copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
            this.chart.addSubtitle((Title)copyright);
        }
        if (!this.settings.getBoolean("showLegend", defaultShowLegend)) {
            this.chart.setLegend(null);
        }
        this.chart.setBackgroundPaint((Paint)Color.white);
    }

    public void save(File outputPath) throws IOException {
        int width = "*".equals(this.settings.getString("width")) ? this.getPreferredWidth() : this.settings.getInt("width", this.getPreferredWidth());
        int height = "*".equals(this.settings.getString("heigth")) ? this.getPreferredHeigth() : this.settings.getInt("height", this.getPreferredHeigth());
        this.save(new File(outputPath, this.filename), width, height);
    }

    public void save(File file, int width, int height) throws IOException {
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
        logger.fine("saved chart as '" + this.filename + "'");
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setSubtitle(String subtitle, String subst) {
        this.setSubtitle(subtitle.replaceAll("%1", subst));
    }

    public void setCategoryAxisLabel(String text) {
        CategoryPlot plot = this.getChart().getCategoryPlot();
        CategoryAxis axis = plot.getDomainAxis();
        axis.setLabel(text);
    }

    public void setValueAxisLabel(String text) {
        CategoryPlot plot = this.getChart().getCategoryPlot();
        ValueAxis axis = plot.getRangeAxis();
        axis.setLabel(text);
    }

    public ReportSettings getSettings() {
        return this.settings;
    }
}

