/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.chart;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractChart;
import de.berlios.statcvs.xml.output.ReportSettings;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;

public class AbstractCombinedChart
extends AbstractChart {
    private CombinedDomainXYPlot combinedPlot;

    public AbstractCombinedChart(ReportSettings settings, String defaultFilename, String defaultSubtitle) {
        super(settings, defaultFilename, defaultSubtitle);
        DateAxis domainAxis = new DateAxis(I18n.tr("Date"));
        domainAxis.setVerticalTickLabels(true);
        this.combinedPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        this.combinedPlot.setGap(10.0);
        this.combinedPlot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(settings.getProjectName(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.combinedPlot, false);
        this.setChart(chart);
    }

    public void addPlot(XYPlot plot) {
        this.combinedPlot.add(plot);
    }

    public int getPlotCount() {
        return this.combinedPlot.getSubplots().size();
    }
}

