/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.chart;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractChart;
import de.berlios.statcvs.xml.chart.RevisionVisitor;
import de.berlios.statcvs.xml.chart.RevisionVisitorFactory;
import de.berlios.statcvs.xml.chart.SymbolicNameAnnotation;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.output.ReportSettings;
import java.awt.Color;
import java.awt.Paint;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.SymbolicName;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYStepRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class AbstractTimeSeriesChart
extends AbstractChart {
    private TimeSeriesCollection tsc = new TimeSeriesCollection();
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    public AbstractTimeSeriesChart(ReportSettings settings, String filename, String title, String rangeLabel) {
        super(settings, filename, title);
        this.setChart(ChartFactory.createTimeSeriesChart((String)settings.getProjectName(), (String)I18n.tr("Date"), (String)rangeLabel, (XYDataset)this.tsc, (boolean)true, (boolean)true, (boolean)false));
        XYPlot plot = this.getChart().getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setVerticalTickLabels(true);
        plot.setRenderer((XYItemRenderer)new XYStepRenderer());
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.red);
        plot.getRenderer().setSeriesPaint(1, (Paint)Color.blue);
        plot.getRenderer().setSeriesPaint(2, (Paint)Color.green);
        plot.getRenderer().setSeriesPaint(3, (Paint)Color.magenta);
        plot.getRenderer().setSeriesPaint(4, (Paint)Color.orange);
        plot.getRenderer().setSeriesPaint(5, (Paint)Color.cyan);
        plot.getRenderer().setSeriesPaint(6, (Paint)Color.pink);
    }

    protected void addSymbolicNames(Iterator it) {
        XYPlot xyplot = this.getChart().getXYPlot();
        while (it.hasNext()) {
            SymbolicName sn = (SymbolicName)it.next();
            xyplot.addAnnotation((XYAnnotation)new SymbolicNameAnnotation(sn));
        }
    }

    protected void addTimeSeries(TimeSeries series, Date firstDate, int firstValue) {
        series.add((RegularTimePeriod)new Millisecond(new Date(firstDate.getTime() - 1L)), (double)firstValue);
        this.tsc.addSeries(series);
    }

    protected void addTimeSeries(TimeSeries series) {
        this.tsc.addSeries(series);
    }

    protected int getSeriesCount() {
        return this.tsc.getSeriesCount();
    }

    protected TimeSeries createTimeSeries(String title, Iterator it, RevisionVisitor visitor) {
        DateTimeSeries result = new DateTimeSeries(title);
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            result.add(rev.getDate(), visitor.visit(rev));
        }
        result.addLast();
        return result;
    }

    protected Map createTimeSeries(Grouper grouper, Iterator it, RevisionVisitorFactory factory) {
        Hashtable<Object, DateTimeSeries> timeSeriesByGroup = new Hashtable<Object, DateTimeSeries>();
        Hashtable<Object, RevisionVisitor> visitorByGroup = new Hashtable<Object, RevisionVisitor>();
        ReportSettings.Predicate predicate = this.getSettings().getOutputPredicate();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            Object group = grouper.getGroup(rev);
            DateTimeSeries series = (DateTimeSeries)((Object)timeSeriesByGroup.get(group));
            RevisionVisitor visitor = (RevisionVisitor)visitorByGroup.get(group);
            if (series == null) {
                series = new DateTimeSeries(grouper.getName(group));
                timeSeriesByGroup.put(group, series);
                visitor = factory.create(group);
                visitorByGroup.put(group, visitor);
            }
            int value = visitor.visit(rev);
            if (predicate != null && !predicate.matches(rev)) continue;
            series.add(rev.getDate(), value);
        }
        Iterator it2 = timeSeriesByGroup.values().iterator();
        while (it2.hasNext()) {
            ((DateTimeSeries)((Object)it2.next())).addLast();
        }
        return timeSeriesByGroup;
    }

    public boolean hasData() {
        Iterator it = this.tsc.getSeries().iterator();
        while (it.hasNext()) {
            TimeSeries series = (TimeSeries)it.next();
            if (series.getItemCount() > 1) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DateTimeSeries
    extends TimeSeries {
        private int currentValue;
        private Date currentDate = null;

        public DateTimeSeries(String name) {
            super(name, class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = AbstractTimeSeriesChart.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        }

        public void add(Date date, int value) {
            if (this.currentDate == null) {
                this.currentDate = date;
            } else if (!date.equals(this.currentDate)) {
                super.add((RegularTimePeriod)new Millisecond(this.currentDate), (double)this.currentValue);
                this.currentDate = date;
            }
            this.currentValue = value;
        }

        public void addLast() {
            if (this.currentDate != null) {
                super.add((RegularTimePeriod)new Millisecond(this.currentDate), (double)this.currentValue);
            }
        }
    }
}

