/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import net.sf.statcvs.model.SymbolicName;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class SymbolicNameAnnotation
implements XYAnnotation {
    private final Color linePaint = Color.GRAY;
    private final Color textPaint = Color.DARK_GRAY;
    private final Stroke stroke = new BasicStroke(1.5f, 0, 0, 10.0f, new float[]{3.5f}, 0.0f);
    private final Font font = new Font("Dialog", 0, 9);
    private SymbolicName symbolicName;

    public SymbolicNameAnnotation(SymbolicName symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void draw(Graphics2D g2d, XYPlot xyPlot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis) {
        PlotOrientation orientation = xyPlot.getOrientation();
        if (domainAxis.getUpperBound() < (double)this.symbolicName.getDate().getTime() || domainAxis.getLowerBound() > (double)this.symbolicName.getDate().getTime()) {
            return;
        }
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)xyPlot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)xyPlot.getRangeAxisLocation(), (PlotOrientation)orientation);
        float x = (float)domainAxis.translateValueToJava2D((double)this.symbolicName.getDate().getTime(), dataArea, domainEdge);
        float y1 = (float)rangeAxis.translateValueToJava2D(rangeAxis.getUpperBound(), dataArea, rangeEdge);
        float y2 = (float)rangeAxis.translateValueToJava2D(rangeAxis.getLowerBound(), dataArea, rangeEdge);
        g2d.setPaint(this.linePaint);
        g2d.setStroke(this.stroke);
        Line2D.Float line = new Line2D.Float(x, y1, x, y2);
        g2d.draw(line);
        float anchorX = x;
        float anchorY = y1 + 2.0f;
        g2d.setFont(this.font);
        g2d.setPaint(this.textPaint);
        RefineryUtilities.drawRotatedString((String)this.symbolicName.getName(), (Graphics2D)g2d, (float)anchorX, (float)anchorY, (TextAnchor)TextAnchor.BOTTOM_RIGHT, (TextAnchor)TextAnchor.BOTTOM_RIGHT, (double)-1.5707963267948966);
    }
}

