/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.model;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.util.FilePatternMatcher;

public class Module
implements Comparable {
    private String name;
    private FilePatternMatcher matcher;
    private Directory directory;
    private SortedSet revisions = new TreeSet();

    public Module(Directory directory) {
        this(directory.getPath());
        this.directory = directory;
    }

    public Module(String name, String pattern) {
        this(name);
        this.matcher = new FilePatternMatcher(pattern);
    }

    public Module(String name) {
        this.name = name;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Module)o).getName());
    }

    public String getName() {
        return this.name;
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public boolean matches(CvsRevision rev) {
        if (this.directory != null && this.directory != rev.getFile().getDirectory()) {
            return false;
        }
        if (this.matcher != null) {
            return this.matcher.matches(rev.getFile().getFilenameWithPath());
        }
        return true;
    }

    public void addRevision(CvsRevision rev) {
        this.revisions.add(rev);
    }
}

