/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.ReportSettings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.IntegerMap;

public class CSVOutputter {
    public static final TimeZone utc = TimeZone.getTimeZone("UTC");
    public static final DateFormat df = new SimpleDateFormat("MM/yyyy", Locale.US);
    public static final Calendar cal;
    public static final String SEPARATOR = ",";
    private static final String LINEBREAK = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(ReportSettings settings, CvsContent content, File file) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        try {
            int totalLoc = 0;
            IntegerMap locByAuthor = new IntegerMap();
            Date lastDate = null;
            int lastMonth = -1;
            int lastYear = -1;
            Iterator it = content.getRevisions().iterator();
            while (it.hasNext()) {
                CvsRevision rev = (CvsRevision)it.next();
                if (lastDate == null) {
                    lastDate = rev.getDate();
                    cal.setTime(lastDate);
                    lastMonth = cal.get(2);
                    lastYear = cal.get(1);
                    CSVOutputter.dumpHeader(out, content, settings.getProjectName());
                } else {
                    cal.setTime(rev.getDate());
                    if (lastMonth != cal.get(2) || lastYear != cal.get(1)) {
                        CSVOutputter.dump(out, content, lastDate, rev.getDate(), totalLoc, locByAuthor);
                        lastDate = rev.getDate();
                        cal.setTime(lastDate);
                        lastMonth = cal.get(2);
                        lastYear = cal.get(1);
                    }
                }
                totalLoc += rev.getLinesDelta();
                locByAuthor.addInt(rev.getAuthor(), rev.getLinesDelta());
            }
            if (lastDate != null) {
                CSVOutputter.dump(out, content, lastDate, totalLoc, locByAuthor);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public static void dumpHeader(Writer out, CvsContent content, String projectName) throws IOException {
        out.write("Project: ");
        out.write(projectName);
        out.write(LINEBREAK);
        out.write("Date");
        out.write(SEPARATOR);
        out.write("Total LOC");
        Iterator it = content.getAuthors().iterator();
        while (it.hasNext()) {
            out.write(SEPARATOR);
            out.write(((Author)it.next()).getName());
        }
        out.write(LINEBREAK);
    }

    public static void dump(Writer out, CvsContent content, Date date, Date nextDate, int totalLoc, IntegerMap locByAuthor) throws IOException {
        System.out.println("writing data for " + date + " - " + nextDate);
        cal.setTime(nextDate);
        int year = cal.get(1);
        int month = cal.get(2);
        cal.setTime(date);
        while (cal.get(1) < year || cal.get(2) < month) {
            CSVOutputter.dump(out, content, cal.getTime(), totalLoc, locByAuthor);
            cal.add(2, 1);
        }
    }

    public static void dump(Writer out, CvsContent content, Date date, int totalLoc, IntegerMap locByAuthor) throws IOException {
        System.out.println("writing data for " + date);
        out.write(df.format(date));
        out.write(SEPARATOR + totalLoc);
        Iterator it = content.getAuthors().iterator();
        while (it.hasNext()) {
            out.write(SEPARATOR + locByAuthor.get(it.next()));
        }
        out.write(LINEBREAK);
    }

    static {
        df.setTimeZone(utc);
        cal = new GregorianCalendar(utc, Locale.US);
    }
}

