/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.chart.AbstractChart;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TooltipMapElement;
import java.io.File;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;

public class ChartReportElement
extends ReportElement {
    AbstractChart chart;

    public ChartReportElement(ReportSettings settings, String defaultTitle, AbstractChart chart, TooltipMapElement tooltipMap) {
        super(settings, defaultTitle);
        this.chart = chart;
        Element element = new Element("img");
        element.setAttribute("src", chart.getFilename());
        if (tooltipMap != null && settings.getBoolean("showImagemap", false)) {
            element.setAttribute("usemap", "#" + tooltipMap.getMapName());
            this.addContent((Content)tooltipMap);
        }
        this.addContent((Content)element);
    }

    public ChartReportElement(AbstractChart chart) {
        this(chart, null);
    }

    public ChartReportElement(AbstractChart chart, TooltipMapElement tooltipMap) {
        this(chart.getSettings(), chart.getSubtitle(), chart, tooltipMap);
    }

    public void saveResources(File outputPath) throws IOException {
        this.chart.save(outputPath);
    }
}

