/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.model.AuthorGrouper;
import de.berlios.statcvs.xml.model.DayGrouper;
import de.berlios.statcvs.xml.model.DirectoryGrouper;
import de.berlios.statcvs.xml.model.FileGrouper;
import de.berlios.statcvs.xml.model.ForEachAuthor;
import de.berlios.statcvs.xml.model.ForEachDirectory;
import de.berlios.statcvs.xml.model.ForEachModule;
import de.berlios.statcvs.xml.model.HourGrouper;
import de.berlios.statcvs.xml.model.Module;
import de.berlios.statcvs.xml.model.ModuleGrouper;
import de.berlios.statcvs.xml.output.DocumentRenderer;
import de.berlios.statcvs.xml.output.EmptyReportException;
import de.berlios.statcvs.xml.output.ModuleBuilder;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.StatCvsDocument;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.Directory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DocumentSuite {
    private static Map filenameByDirectoryPath = new Hashtable();
    private static Map filenameByAuthorName = new Hashtable();
    private static Map filenameByModuleName = new Hashtable();
    private static Map documentTitleByFilename = new LinkedHashMap();
    private static Logger logger = Logger.getLogger((class$de$berlios$statcvs$xml$output$DocumentSuite == null ? (class$de$berlios$statcvs$xml$output$DocumentSuite = DocumentSuite.class$("de.berlios.statcvs.xml.output.DocumentSuite")) : class$de$berlios$statcvs$xml$output$DocumentSuite).getName());
    private CvsContent content;
    private Document suite;
    private ReportSettings defaultSettings = new ReportSettings();
    static /* synthetic */ Class class$de$berlios$statcvs$xml$output$DocumentSuite;
    static /* synthetic */ Class class$net$sf$statcvs$model$CvsContent;
    static /* synthetic */ Class class$de$berlios$statcvs$xml$output$ReportSettings;

    public DocumentSuite(URL url, CvsContent content) throws IOException {
        this.content = content;
        try {
            SAXBuilder builder = new SAXBuilder();
            this.suite = builder.build(url);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public StatCvsDocument createDocument(Element root, DocumentRenderer renderer, ReportSettings settings) throws IOException {
        ReportSettings documentSettings = this.readAttributes(settings, root);
        settings.setId(documentSettings.getString("filename"));
        ReportSettings reportSettings = new ReportSettings(settings);
        ArrayList<Report> reports = new ArrayList<Report>();
        int maxPages = 0;
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            Report report;
            Element element = (Element)it.next();
            if ("settings".equals(element.getName())) {
                reportSettings.load(element);
                continue;
            }
            if (!"report".equals(element.getName()) || (report = this.createReport(element, reportSettings)) == null || report.getPageCount() == 0) continue;
            reports.add(report);
            maxPages = Math.max(report.getPageCount(), maxPages);
        }
        StatCvsDocument firstPage = null;
        int i = 0;
        while (i < maxPages) {
            documentSettings.setPageNr(i);
            StatCvsDocument document = new StatCvsDocument(documentSettings);
            if (i == 0) {
                firstPage = document;
            }
            if (maxPages > 1) {
                ReportElement pager = new ReportElement();
                pager.addContent((Content)this.createPagerElement(i, maxPages, firstPage.getFilename()));
                document.getRootElement().addContent((Content)pager);
            }
            int r = 0;
            while (r < reports.size()) {
                ReportElement re = ((Report)reports.get(r)).getPage(i);
                if (re != null) {
                    document.getRootElement().addContent((Content)re);
                }
                ++r;
            }
            renderer.render(document);
            ++i;
        }
        return firstPage;
    }

    private Element createPagerElement(int currPage, int total, String baseName) {
        Element pager = new Element("pager");
        pager.setAttribute("current", "" + (currPage + 1));
        pager.setAttribute("total", "" + total);
        int i = 0;
        while (i < total) {
            Element page = new Element("page");
            page.setAttribute("filename", baseName + (i == 0 ? "" : "_" + i));
            page.setAttribute("nr", "" + (i + 1));
            pager.addContent((Content)page);
            ++i;
        }
        return pager;
    }

    private Report createReport(Element root, ReportSettings documentSettings) {
        block17: {
            ReportSettings reportSettings = this.readAttributes(documentSettings, root);
            String value = reportSettings.getString("groupby", null);
            if ("author".equals(value)) {
                reportSettings.setGrouper(new AuthorGrouper());
            } else if ("day".equals(value)) {
                reportSettings.setGrouper(new DayGrouper());
            } else if ("directory".equals(value)) {
                reportSettings.setGrouper(new DirectoryGrouper());
            } else if ("file".equals(value)) {
                reportSettings.setGrouper(new FileGrouper());
            } else if ("hour".equals(value)) {
                reportSettings.setGrouper(new HourGrouper());
            } else if ("module".equals(value)) {
                reportSettings.setGrouper(new ModuleGrouper(reportSettings.getModules(this.content)));
            }
            String className = root.getAttributeValue("class");
            if (className == null) break block17;
            reportSettings.setId(className);
            if (className.indexOf(".") == -1) {
                className = "de.berlios.statcvs.xml.report." + className;
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod("generate", class$net$sf$statcvs$model$CvsContent == null ? (class$net$sf$statcvs$model$CvsContent = DocumentSuite.class$("net.sf.statcvs.model.CvsContent")) : class$net$sf$statcvs$model$CvsContent, class$de$berlios$statcvs$xml$output$ReportSettings == null ? (class$de$berlios$statcvs$xml$output$ReportSettings = DocumentSuite.class$("de.berlios.statcvs.xml.output.ReportSettings")) : class$de$berlios$statcvs$xml$output$ReportSettings);
                try {
                    Object report = m.invoke(null, this.content, reportSettings);
                    return report instanceof Report ? (Report)report : null;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getCause() instanceof EmptyReportException)) {
                        throw e;
                    }
                    logger.warning("Empty Report");
                }
            }
            catch (Exception e) {
                logger.warning("Could not generate report: " + e);
                e.printStackTrace();
            }
        }
        return null;
    }

    public void generate(DocumentRenderer renderer, ReportSettings defaultSettings) throws IOException {
        this.defaultSettings = defaultSettings;
        Iterator it = this.suite.getRootElement().getChildren().iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if ("settings".equals(element.getName())) {
                defaultSettings.load(element);
                continue;
            }
            if (!"document".equals(element.getName())) continue;
            this.renderDocument(renderer, element);
        }
        renderer.postRender();
    }

    private void renderDocument(DocumentRenderer renderer, Element element) throws IOException {
        String value = element.getAttributeValue("foreach");
        if (value == null) {
            StatCvsDocument document = this.createDocument(element, renderer, this.defaultSettings);
            documentTitleByFilename.put(document.getFilename(), document.getTitle());
        } else if ("author".equals(value)) {
            Iterator i = this.content.getAuthors().iterator();
            while (i.hasNext()) {
                Author author = (Author)i.next();
                ReportSettings settings = new ReportSettings(this.defaultSettings);
                settings.setForEach(new ForEachAuthor(author));
                StatCvsDocument doc = this.createDocument(element, renderer, settings);
                if (doc == null) continue;
                filenameByAuthorName.put(author.getName(), doc.getFilename());
            }
        } else if ("directory".equals(value)) {
            Iterator i = this.content.getDirectories().iterator();
            while (i.hasNext()) {
                Directory dir = (Directory)i.next();
                if (dir.isEmpty()) continue;
                ReportSettings settings = new ReportSettings(this.defaultSettings);
                settings.setForEach(new ForEachDirectory(dir));
                StatCvsDocument doc = this.createDocument(element, renderer, settings);
                if (doc == null) continue;
                filenameByDirectoryPath.put(dir.getPath(), doc.getFilename());
            }
        } else if ("module".equals(value)) {
            ModuleBuilder builder = new ModuleBuilder(this.defaultSettings.getModules(this.content), this.content.getRevisions().iterator());
            Iterator i = builder.getModules().iterator();
            while (i.hasNext()) {
                Module module = (Module)i.next();
                ReportSettings settings = new ReportSettings(this.defaultSettings);
                settings.setForEach(new ForEachModule(module));
                StatCvsDocument doc = this.createDocument(element, renderer, settings);
                if (doc == null) continue;
                filenameByModuleName.put(module.getName(), doc.getFilename());
            }
        } else {
            throw new IOException("Invalid foreach value");
        }
    }

    private ReportSettings readAttributes(ReportSettings parentSettings, Element root) {
        ReportSettings settings = new ReportSettings(parentSettings);
        Iterator it = root.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute setting = (Attribute)it.next();
            if (setting.getName().startsWith("_")) continue;
            settings.put(setting.getName(), setting.getValue());
        }
        return settings;
    }

    public static String getAuthorFilename(String name) {
        return (String)filenameByAuthorName.get(name);
    }

    public static String getDirectoryFilename(String path) {
        return (String)filenameByDirectoryPath.get(path);
    }

    public static String getModuleFilename(String module) {
        return (String)filenameByModuleName.get(module);
    }

    public static Map getDocuments() {
        return documentTitleByFilename;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

