/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.XMLOutputter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class HTMLOutputter
extends XMLOutputter {
    private static final Set elementsWithoutEndTags = new HashSet();

    public HTMLOutputter(Format format) {
        super(format);
    }

    protected void printElement(Element element, Writer out, int level, XMLOutputter.NamespaceStack namespaces) throws IOException {
        element.setNamespace(Namespace.NO_NAMESPACE);
        if (elementsWithoutEndTags.contains(element.getQualifiedName())) {
            out.write("<");
            out.write(element.getQualifiedName());
            List attributes = element.getAttributes();
            if (attributes != null) {
                this.printAttributes(out, attributes, element, namespaces);
            }
            out.write(">");
        } else {
            super.printElement(out, element, level, namespaces);
        }
    }

    public void output(Document document, Writer out) throws IOException {
        DocType type = new DocType("html", "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd");
        document.setDocType(type);
        super.output(document, out);
    }

    static {
        elementsWithoutEndTags.add("area");
        elementsWithoutEndTags.add("base");
        elementsWithoutEndTags.add("basefont");
        elementsWithoutEndTags.add("br");
        elementsWithoutEndTags.add("col");
        elementsWithoutEndTags.add("frame");
        elementsWithoutEndTags.add("hr");
        elementsWithoutEndTags.add("img");
        elementsWithoutEndTags.add("input");
        elementsWithoutEndTags.add("isindex");
        elementsWithoutEndTags.add("link");
        elementsWithoutEndTags.add("meta");
        elementsWithoutEndTags.add("param");
    }
}

