/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.DocumentRenderer;
import de.berlios.statcvs.xml.output.HTMLOutputter;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.XMLRenderer;
import de.berlios.statcvs.xml.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.util.FileUtils;
import org.jdom.output.Format;

public class HTMLRenderer
extends XMLRenderer {
    private static Logger logger = Logger.getLogger("net.sf.statcvs.output.XMLRenderer");
    private ReportSettings settings;

    public HTMLRenderer(ReportSettings settings, Transformer transformer, File outputPath) {
        super(transformer, outputPath);
        this.settings = settings;
        String ext = (String)transformer.getParameter("ext");
        this.setExtension(ext != null ? ext : ".html");
        Format format = XMLRenderer.createDefaultFormat();
        format.setOmitDeclaration(true);
        format.setOmitEncoding(true);
        HTMLOutputter xout = new HTMLOutputter(format);
        this.setOutputter(xout);
    }

    public void postRender() {
        super.postRender();
        String filename = this.settings.getString("customCss");
        if (filename != null) {
            FileHelper.copyResource(filename, this.getOutputPath());
        }
        FileHelper.copyResource("resources/statcvs.css", this.getOutputPath());
    }

    public static DocumentRenderer create(CvsContent content, ReportSettings settings) throws IOException {
        Transformer transformer;
        String stylesheet = settings.getString("html-xsl", "resources/statcvs2html.xsl");
        logger.info("Using " + stylesheet + " as stylesheet");
        StreamSource source = new StreamSource(FileHelper.getResource(stylesheet).toString());
        try {
            transformer = TransformerFactory.newInstance().newTransformer(source);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        transformer.setParameter("ext", ".html");
        String filename = settings.getString("customCss");
        if (filename != null) {
            transformer.setParameter("customCss", FileUtils.getFilenameWithoutPath(filename));
        }
        return new HTMLRenderer(settings, transformer, settings.getOutputPath());
    }
}

