/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.DocumentRenderer;
import de.berlios.statcvs.xml.output.HTMLRenderer;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.util.FileHelper;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.util.FileUtils;

public class PHPRenderer {
    private static Logger logger = Logger.getLogger("net.sf.statcvs.output.PHPRenderer");

    public static DocumentRenderer create(CvsContent content, ReportSettings settings) throws IOException {
        Transformer transformer;
        String stylesheet = settings.getString("html-xsl", "resources/statcvs2html.xsl");
        logger.info("Using " + stylesheet + " as stylesheet");
        StreamSource source = new StreamSource(FileHelper.getResource(stylesheet).toString());
        try {
            transformer = TransformerFactory.newInstance().newTransformer(source);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        transformer.setParameter("ext", ".php");
        String filename = settings.getString("customCss");
        if (filename != null) {
            transformer.setParameter("customCss", FileUtils.getFilenameWithoutPath(filename));
        }
        return new HTMLRenderer(settings, transformer, settings.getOutputPath());
    }
}

