/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.WebRepositoryFactory;
import de.berlios.statcvs.xml.model.ForEachObject;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.model.Module;
import de.berlios.statcvs.xml.util.ScriptHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.regex.Pattern;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.SymbolicName;
import net.sf.statcvs.output.ChoraIntegration;
import net.sf.statcvs.output.CvswebIntegration;
import net.sf.statcvs.output.ViewCvsIntegration;
import net.sf.statcvs.output.WebRepositoryIntegration;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.jdom.Element;

public class ReportSettings
extends Hashtable {
    public static final String PRIVATE_SETTING_PREFIX = "_";
    protected ReportSettings defaults;
    private Map uberSettings;
    static /* synthetic */ Class class$de$berlios$statcvs$xml$output$HTMLRenderer;
    static /* synthetic */ Class class$de$berlios$statcvs$xml$output$XDocRenderer;
    static /* synthetic */ Class class$de$berlios$statcvs$xml$output$XMLRenderer;

    public ReportSettings(Hashtable uberSettings) {
        this.uberSettings = uberSettings;
    }

    public ReportSettings() {
        this(new Hashtable());
    }

    public ReportSettings(ReportSettings defaults) {
        this.defaults = defaults;
        this.uberSettings = defaults.uberSettings;
    }

    public Object get(Object key) {
        return this.get(key, null);
    }

    public Object get(Object key, Object defaultValue) {
        String id;
        Object uberValue = this.uberSettings.get(key);
        if (uberValue != null) {
            return uberValue;
        }
        if (!key.equals("id") && (id = this.getId()) != null) {
            ReportSettings rootSettings = this.getRootDefaults();
            while (true) {
                Object idValue;
                if ((idValue = rootSettings.get1(id + "." + key, null)) != null) {
                    return idValue;
                }
                int i = id.lastIndexOf(".");
                if (i == -1) break;
                id = id.substring(0, i);
            }
        }
        return this.get1(key, defaultValue);
    }

    protected Object get1(Object key, Object defaultValue) {
        Object o = super.get(key);
        return o != null ? o : (this.defaults != null ? this.defaults.get1(key, defaultValue) : defaultValue);
    }

    private ReportSettings getRootDefaults() {
        ReportSettings root = this;
        while (root.defaults != null) {
            root = root.defaults;
        }
        return root;
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        return Boolean.valueOf(this.getString(key, defaultValue + ""));
    }

    public Iterator getDirectoryIterator(CvsContent content) {
        ForEachObject o = this.getForEach();
        Iterator it = o != null ? o.getDirectoryIterator(content) : content.getDirectories().iterator();
        return this.getFilterIterator(it);
    }

    public Iterator getFileIterator(CvsContent content) {
        ForEachObject o = this.getForEach();
        Iterator it = o != null ? o.getFileIterator(content) : content.getFiles().iterator();
        return this.getFilterIterator(it);
    }

    public String getFilenameId() {
        String postfix = this.getForeachId() == null ? "" : PRIVATE_SETTING_PREFIX + this.getForeachId();
        return postfix + (this.getGroupById() == null ? "" : "_by_" + this.getGroupById());
    }

    public Iterator getFilterIterator(Iterator it) {
        String expression = this.getString("inputFilter", null);
        if (expression != null) {
            try {
                return new FilteredIterator(it, new ExpressionPredicate(expression));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return it;
    }

    public ForEachObject getForEach() {
        return (ForEachObject)this.get("_foreach");
    }

    public Grouper getGrouper(Grouper defaultValue) {
        return (Grouper)this.get("_groupby", defaultValue);
    }

    public Grouper getGrouper() {
        return this.getGrouper(null);
    }

    private String getGroupById() {
        Grouper o = this.getGrouper();
        return o != null ? o.getID() : null;
    }

    public Object getForEachObject() {
        ForEachObject o = this.getForEach();
        return o != null ? o.getObject() : null;
    }

    public String getForeachId() {
        ForEachObject o = this.getForEach();
        return o != null ? o.getID() : null;
    }

    public String getId() {
        return this.getString("id");
    }

    public int getInt(Object key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key, defaultValue + ""));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(Object key, long defaultValue) {
        try {
            return Long.parseLong(this.getString(key, defaultValue + ""));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getLimit() {
        return this.getLimit(20);
    }

    public int getLimit(int defaultValue) {
        return this.getInt("limit", defaultValue);
    }

    public boolean isPaging() {
        return this.getBoolean("paging", false);
    }

    public int getItemsPerPage() {
        return this.getItemsPerPage(20);
    }

    public int getItemsPerPage(int defaultValue) {
        if (defaultValue == 0) {
            throw new IllegalArgumentException("itemsPerPage may not be 0");
        }
        int items = this.getInt("itemsPerPage", defaultValue);
        return items == 0 ? defaultValue : items;
    }

    public int getPageNr() {
        return this.getInt("_pageNr", 0);
    }

    public void setPageNr(int page) {
        this.put("_pageNr", "" + page);
    }

    public List getModules(CvsContent content) {
        LinkedList<Module> modules = new LinkedList<Module>();
        Object o = this.get("modules", null);
        if (o instanceof Map) {
            Map map = (Map)o;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                modules.add(new Module(key.toString(), map.get(key).toString()));
            }
        } else {
            SortedSet directories = content.getDirectories();
            Iterator it = directories.iterator();
            while (it.hasNext()) {
                Directory dir = (Directory)it.next();
                if (dir.isRoot()) continue;
                modules.add(new Module(dir));
            }
        }
        return modules;
    }

    public File getOutputPath() {
        return new File(this.getString("outputDir", "statcvs-xml-out"));
    }

    public String getProjectName() {
        return this.getString("projectName", "");
    }

    public String getRendererClassname() {
        String renderer = this.getString("renderer", "html");
        if (renderer.equals("html")) {
            return (class$de$berlios$statcvs$xml$output$HTMLRenderer == null ? (class$de$berlios$statcvs$xml$output$HTMLRenderer = ReportSettings.class$("de.berlios.statcvs.xml.output.HTMLRenderer")) : class$de$berlios$statcvs$xml$output$HTMLRenderer).getName();
        }
        if (renderer.equals("xdoc")) {
            return (class$de$berlios$statcvs$xml$output$XDocRenderer == null ? (class$de$berlios$statcvs$xml$output$XDocRenderer = ReportSettings.class$("de.berlios.statcvs.xml.output.XDocRenderer")) : class$de$berlios$statcvs$xml$output$XDocRenderer).getName();
        }
        if (renderer.equals("xml")) {
            return (class$de$berlios$statcvs$xml$output$XMLRenderer == null ? (class$de$berlios$statcvs$xml$output$XMLRenderer = ReportSettings.class$("de.berlios.statcvs.xml.output.XMLRenderer")) : class$de$berlios$statcvs$xml$output$XMLRenderer).getName();
        }
        return renderer;
    }

    public Iterator getRevisionIterator(CvsContent content) {
        ForEachObject o = this.getForEach();
        Iterator it = o != null ? o.getRevisionIterator(content) : content.getRevisions().iterator();
        return this.getFilterIterator(it);
    }

    public String getString(Object key, String defaultValue) {
        return (String)this.get(key, defaultValue);
    }

    public String getString(Object key) {
        return this.getString(key, null);
    }

    public String getSubtitlePostfix() {
        String postfix = this.getForeachId() == null ? "" : I18n.tr(" for {0}", this.getForeachId());
        return postfix + (this.getGroupById() == null ? "" : I18n.tr(" (per {0})", this.getGroupById()));
    }

    public Iterator getSymbolicNameIterator(CvsContent content) {
        String regexp = this.getString("tags", null);
        if (regexp == null) {
            return content.getSymbolicNames().iterator();
        }
        final Pattern pattern = Pattern.compile(regexp);
        Predicate predicate = new Predicate(){

            public boolean matches(Object o) {
                SymbolicName tag = (SymbolicName)o;
                return pattern.matcher(tag.getName()).matches();
            }
        };
        return new FilteredIterator(content.getSymbolicNames().iterator(), predicate);
    }

    public WebRepositoryIntegration getWebRepository() {
        WebRepositoryIntegration repository = (WebRepositoryIntegration)this.get("_webRepository");
        if (repository != null) {
            return repository;
        }
        if (this.getString("webRepository") != null) {
            repository = WebRepositoryFactory.getInstance(this.getString("webRepository"));
        } else if (this.getString("viewcvs") != null) {
            repository = new ViewCvsIntegration(this.getString("viewcvs"));
        } else if (this.getString("cvsweb") != null) {
            repository = new CvswebIntegration(this.getString("cvsweb"));
        } else if (this.getString("chora") != null) {
            repository = new ChoraIntegration(this.getString("chora"));
        }
        if (repository != null) {
            this.uberSettings.put("_webRepository", repository);
        }
        return repository;
    }

    public void load(Element root) {
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            Element setting = (Element)it.next();
            Object key = this.getKey(setting);
            if (key == null) continue;
            this.put(key, this.getValue(setting));
        }
    }

    private Object getKey(Element setting) {
        String key = setting.getName();
        if ("setting".equals(key)) {
            key = setting.getAttributeValue("key");
        }
        return key != null && !key.startsWith(PRIVATE_SETTING_PREFIX) ? key : null;
    }

    private Object getValue(Element setting) {
        if ("map".equals(setting.getAttributeValue("type"))) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            Iterator it = setting.getChildren().iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                Object key = this.getKey(child);
                if (key == null) continue;
                map.put(key, this.getValue(child));
            }
            return map;
        }
        return setting.getText() == null ? "" : setting.getTextTrim();
    }

    public void setForEach(ForEachObject object) {
        if (object == null) {
            this.remove("_foreach");
        } else {
            this.put("_foreach", object);
        }
    }

    public void setGrouper(Grouper grouper) {
        this.put("_groupby", grouper);
    }

    public Predicate getOutputPredicate() {
        String filter = this.getString("outputFilter");
        try {
            if (filter != null) {
                return new ExpressionPredicate(filter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getFullname(Author author) {
        Object o = this.get("authors", null);
        if (o instanceof Map) {
            Map map = (Map)o;
            String full = (String)map.get(author.getName());
            return full == null ? author.getName() : full;
        }
        return author.getName();
    }

    public String getAuthorPic(Author author, String defaultPic) {
        Object o = this.get("authorPics", null);
        if (o instanceof Map) {
            Map map = (Map)o;
            String pic = (String)map.get(author.getName());
            return pic == null ? defaultPic : pic;
        }
        return defaultPic;
    }

    public void setId(String id) {
        this.put("id", this.defaults != null && this.defaults.getId() != null ? this.defaults.getId() + "." + id : id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Predicate {
        public boolean matches(Object var1);
    }

    public static class FilteredIterator
    implements Iterator {
        private Iterator it;
        private Object lookAhead;
        private Predicate predicate;

        public FilteredIterator(Iterator it, Predicate predicate) {
            this.it = it;
            this.predicate = predicate;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.lookAhead == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.lookAhead = this.it.next();
                if (!this.predicate.matches(this.lookAhead)) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.it.hasNext())
            }
lbl7:
            // 1 sources

            this.lookAhead = null;
            return false;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            if (this.lookAhead == null) ** GOTO lbl8
            current = this.lookAhead;
            this.lookAhead = null;
            return current;
lbl-1000:
            // 1 sources

            {
                o = this.it.next();
                if (!this.predicate.matches(o)) continue;
                return o;
lbl8:
                // 2 sources

                ** while (this.it.hasNext())
            }
lbl9:
            // 1 sources

            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ExpressionPredicate
    implements Predicate {
        private JexlContext context;
        private Expression expression;

        public ExpressionPredicate(String expressionSource) throws Exception {
            this.expression = ExpressionFactory.createExpression((String)expressionSource);
            this.context = JexlHelper.createContext();
            this.context.getVars().put("util", new ScriptHelper());
        }

        public boolean matches(Object o) {
            if (o instanceof CvsRevision) {
                this.context.getVars().put("rev", o);
                this.context.getVars().put("date", ((CvsRevision)o).getDate());
            }
            this.context.getVars().put("value", o);
            try {
                Object res = this.expression.evaluate(this.context);
                return res instanceof Boolean ? (Boolean)res : false;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

