/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;

public class StatCvsDocument
extends Document {
    private static int documentNumber = 0;
    private String filename;
    private String title;
    private ReportSettings settings;

    public StatCvsDocument(ReportSettings settings) {
        this.settings = settings;
        this.filename = StringHelper.escapeFilename(settings.getString("filename", "document_" + ++documentNumber).replaceAll("%1", settings.getFilenameId()) + (settings.getPageNr() == 0 ? "" : "_" + settings.getPageNr()));
        this.title = settings.getString("title", "").replaceAll("%1", settings.getSubtitlePostfix());
        Element root = new Element("document");
        root.setAttribute("title", this.title);
        root.setAttribute("name", this.filename);
        this.setRootElement(root);
    }

    public void saveResources(File outputPath) throws IOException {
        Iterator it = this.getRootElement().getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ReportElement)) continue;
            ((ReportElement)((Object)o)).saveResources(outputPath);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public ReportSettings getSettings() {
        return this.settings;
    }

    public String getTitle() {
        return this.title;
    }
}

