/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.model.Module;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.Separable;
import de.berlios.statcvs.xml.util.Formatter;
import de.berlios.statcvs.xml.util.StringHelper;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.WebRepositoryIntegration;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class TableElement
extends Element
implements Separable {
    ReportSettings settings;
    String[] headers;

    public TableElement(ReportSettings settings, String[] headers) {
        super("table");
        this.settings = settings;
        this.headers = headers;
        if (headers != null) {
            Element row = new Element("tr");
            int i = 0;
            while (i < headers.length) {
                if (this.showColumn(i + 1)) {
                    Element th = new Element("th");
                    th.addContent(headers[i]);
                    row.addContent((Content)th);
                }
                ++i;
            }
            this.addContent((Content)row);
        }
    }

    public boolean showColumn(int i) {
        return this.settings.getString("showColumns", "123456789").indexOf(Integer.toString(i)) != -1;
    }

    public RowElement addRow() {
        RowElement row = new RowElement();
        this.addContent((Content)row);
        return row;
    }

    public void addRow(RowElement row) {
        this.addContent((Content)row);
    }

    public Element getPage(int page) {
        if (!this.settings.isPaging()) {
            return (Element)this.clone();
        }
        int lower = page * this.settings.getItemsPerPage();
        int upper = lower + this.settings.getItemsPerPage();
        if (upper > this.getContent().size() - 1) {
            upper = this.getContent().size() - 1;
        }
        List items = this.getContent().subList(lower + 1, upper + 1);
        TableElement tablePart = new TableElement(this.settings, this.headers);
        int i = 0;
        while (i < items.size()) {
            tablePart.addContent((Content)((Element)((Element)items.get(i)).clone()));
            ++i;
        }
        return tablePart;
    }

    public int getPageCount() {
        int items = this.getContent().size() - 1;
        return this.isEmpty() ? 0 : (this.settings.isPaging() ? (int)Math.ceil((double)items / (double)this.settings.getItemsPerPage()) : 1);
    }

    public boolean isEmpty() {
        return this.getChildren().size() == 1;
    }

    public class RowElement
    extends Element {
        int columnCount;

        public RowElement() {
            super("row");
            this.columnCount = 0;
        }

        public Element addContent(Element element) {
            return TableElement.this.showColumn(++this.columnCount) ? (Element)super.addContent((Content)element) : null;
        }

        public RowElement addInteger(String key, int value, double percentage) {
            Element number = new Element("number");
            number.setAttribute("key", key);
            number.setText("" + value);
            if (TableElement.this.settings.getBoolean("showPercent", true)) {
                number.setAttribute("percentage", Formatter.formatNumber(percentage, 1));
            }
            this.addContent(number);
            return this;
        }

        public RowElement addInteger(String key, int value) {
            Element number = new Element("number");
            number.setAttribute("key", key);
            number.setText("" + value);
            this.addContent(number);
            return this;
        }

        public RowElement addDouble(String key, double value, double percentage) {
            Element number = new Element("number");
            number.setAttribute("key", key);
            number.setText(Formatter.formatNumber(value, 2));
            if (TableElement.this.settings.getBoolean("showPercent", true)) {
                number.setAttribute("percentage", Formatter.formatNumber(percentage, 1));
            }
            this.addContent(number);
            return this;
        }

        public RowElement addDouble(String key, double value) {
            Element number = new Element("number");
            number.setAttribute("key", key);
            number.setText(Formatter.formatNumber(value, 2));
            this.addContent(number);
            return this;
        }

        public RowElement addString(String key, String value) {
            Element element = new Element("string");
            element.setAttribute("key", key);
            element.addContent((Content)new CDATA(StringHelper.replaceNonXMLCharacters(value)));
            this.addContent(element);
            return this;
        }

        public RowElement addLink(String key, String value, String url) {
            this.addContent(new Element("link").setAttribute("key", key).setAttribute("url", url).setText(StringHelper.replaceNonXMLCharacters(value)));
            return this;
        }

        public RowElement addImage(String key, String src) {
            this.addContent(new Element("image").setAttribute("src", src));
            return this;
        }

        public RowElement addDirectory(Directory dir) {
            this.addContent(new Element("directory").setAttribute("name", dir.getPath()));
            return this;
        }

        public RowElement addModule(Module module) {
            this.addContent(new Element("module").setAttribute("name", module.getName()));
            return this;
        }

        public RowElement addAuthor(Author author) {
            Element authEl = new Element("author");
            authEl.setAttribute("name", author.getName());
            authEl.setAttribute("fullname", TableElement.this.settings.getFullname(author));
            this.addContent(authEl);
            return this;
        }

        public RowElement addFile(CvsFile file) {
            WebRepositoryIntegration webRepository = TableElement.this.settings.getWebRepository();
            return this.addLink("file", file.getFilenameWithPath(), webRepository == null ? "" : webRepository.getFileViewUrl(file));
        }

        public RowElement addGroup(Grouper grouper, Object group) {
            grouper.addElement(group, this);
            return this;
        }

        public RowElement addDirectoryTree(Directory directory, int depth) {
            Element element = new Element("directoryTree");
            element.setAttribute("depth", "" + depth);
            element.setAttribute("name", directory.isRoot() ? I18n.tr("[root]") : directory.getName());
            element.setAttribute("path", directory.getPath());
            if (directory.isEmpty()) {
                element.setAttribute("removed", "true");
            }
            this.addContent(element);
            return this;
        }

        public RowElement addCommit(Commit commit) {
            Element comEl = new Element("commit");
            comEl.setAttribute("changedfiles", "" + commit.getAffectedFiles().size());
            Iterator it = commit.getRevisions().iterator();
            int locSum = 0;
            while (it.hasNext()) {
                CvsRevision each = (CvsRevision)it.next();
                locSum += each.getNewLines();
            }
            comEl.setAttribute("changedlines", "" + locSum);
            Element comment = new Element("comment");
            comment.addContent((Content)new CDATA(StringHelper.replaceNonXMLCharacters(commit.getComment())));
            comEl.addContent((Content)comment);
            Element files = new Element("files");
            comEl.addContent((Content)files);
            Iterator revIt = commit.getRevisions().iterator();
            while (revIt.hasNext()) {
                CvsRevision rev = (CvsRevision)revIt.next();
                Element file = new Element("file");
                files.addContent((Content)file);
                file.setAttribute("name", rev.getFile().getFilename());
                file.setAttribute("directory", rev.getFile().getDirectory().getPath());
                file.setAttribute("revision", rev.getRevisionNumber());
                WebRepositoryIntegration webRepository = TableElement.this.settings.getWebRepository();
                if (webRepository != null) {
                    CvsRevision previous = rev.getPreviousRevision();
                    String url = previous == null ? webRepository.getFileViewUrl(rev) : webRepository.getDiffUrl(previous, rev);
                    file.setAttribute("url", url);
                }
                if (rev.isInitialRevision()) {
                    file.setAttribute("action", "added");
                    if (rev.getFile().getCurrentLinesOfCode() == 0) continue;
                    file.setAttribute("lines", "" + rev.getLines());
                    continue;
                }
                if (rev.isDead()) {
                    file.setAttribute("action", "deleted");
                    continue;
                }
                file.setAttribute("action", "changed");
                int delta = rev.getLinesDelta();
                int linesAdded = rev.getReplacedLines() + (delta > 0 ? delta : 0);
                int linesRemoved = rev.getReplacedLines() - (delta < 0 ? delta : 0);
                file.setAttribute("added", "" + linesAdded);
                file.setAttribute("removed", "" + linesRemoved);
            }
            this.addContent(comEl);
            return this;
        }

        public RowElement addDate(String key, Date date) {
            return this.addString(key, Formatter.formatDate(date));
        }

        public RowElement addPercent(String key, double percent) {
            Element number = new Element("number");
            number.setAttribute("key", key);
            number.addContent((Content)new CDATA(Formatter.formatNumber(percent, 1)));
            this.addContent(number);
            return this;
        }
    }
}

