/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.util.Formatter;
import java.util.Date;
import org.jdom.Content;
import org.jdom.Element;

public class TextElement
extends Element {
    ReportSettings settings;

    public TextElement(ReportSettings settings, String key) {
        super("container");
        this.settings = settings;
        this.setAttribute("key", key);
    }

    public ListElement addList() {
        ListElement element = new ListElement();
        this.addContent((Content)element);
        return element;
    }

    public TextElement addPeriod(String name, Date from, Date to) {
        Element element = new Element("period");
        element.setAttribute("name", name);
        element.setAttribute("from", Formatter.formatDate(from));
        if (to != null) {
            element.setAttribute("to", Formatter.formatDate(to));
        }
        this.addContent((Content)element);
        return this;
    }

    public TextElement addPeriod(String name, Date at) {
        return this.addPeriod(name, at, null);
    }

    public TextElement addValue(String key, long value, String description) {
        Element element = new Element("value");
        element.setAttribute("key", this.name);
        element.setAttribute("value", value + "");
        element.setText(description);
        this.addContent((Content)element);
        return this;
    }

    public TextElement addValue(String key, double value, double percentValue, String description) {
        Element element = new Element("value");
        element.setAttribute("key", this.name);
        element.setAttribute("value", value + "");
        element.setAttribute("percentage", value + "");
        element.setText(description);
        this.addContent((Content)element);
        return this;
    }

    public TextElement addValue(String key, double value, String description) {
        Element element = new Element("value");
        element.setAttribute("key", this.name);
        element.setAttribute("value", Formatter.formatNumber(value, 1));
        element.setText(description);
        this.addContent((Content)element);
        return this;
    }

    public TextElement addValue(String key, String value, String description) {
        Element element = new Element("value");
        element.setAttribute("key", this.name);
        element.setAttribute("value", value);
        element.setText(description);
        this.addContent((Content)element);
        return this;
    }

    public TextElement addText(String text) {
        Element element = new Element("text");
        element.addContent(text);
        this.addContent((Content)element);
        return this;
    }

    public class ListElement
    extends Element {
        public ListElement() {
            super("ul");
        }

        public ListElement addItem(String filename, String link) {
            Element element = new Element("link");
            element.setAttribute("ref", filename);
            element.setText(link);
            Element item = new Element("li");
            item.addContent((Content)element);
            this.addContent((Content)item);
            return this;
        }

        public ListElement addString(String text) {
            Element item = new Element("li");
            item.setText(text);
            this.addContent((Content)item);
            return this;
        }
    }
}

