/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.output;

import de.berlios.statcvs.xml.output.DocumentRenderer;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.StatCvsDocument;
import de.berlios.statcvs.xml.output.XMLOutputter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.statcvs.model.CvsContent;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.transform.JDOMSource;

public class XMLRenderer
implements DocumentRenderer {
    private File outputPath;
    private static Logger logger = Logger.getLogger("net.sf.statcvs.output.XMLRenderer");
    private XMLOutputter out;
    private Transformer transformer;
    private String extension;

    public XMLRenderer(Transformer transformer, File outputPath) {
        this.transformer = transformer;
        this.outputPath = outputPath;
        this.setExtension(".xml");
        XMLOutputter xout = new XMLOutputter(XMLRenderer.createDefaultFormat());
        this.setOutputter(xout);
    }

    public XMLRenderer(File outputPath) {
        this(null, outputPath);
    }

    public static DocumentRenderer create(CvsContent content, ReportSettings settings) throws IOException {
        return new XMLRenderer(settings.getOutputPath());
    }

    public static Format createDefaultFormat() {
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setExpandEmptyElements(false);
        return format;
    }

    public void setOutputter(XMLOutputter outputter) {
        this.out = outputter;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }

    public String getExtension() {
        return this.extension;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(StatCvsDocument document) throws IOException {
        logger.info("Rendering " + document.getFilename());
        File file = new File(this.outputPath, document.getFilename() + this.extension);
        FileOutputStream outStream = new FileOutputStream(file);
        document.saveResources(this.outputPath);
        try {
            if (this.transformer != null) {
                StreamResult result = new StreamResult(outStream);
                try {
                    this.transformer.transform((Source)new JDOMSource((Document)document), result);
                }
                catch (TransformerException e) {
                    logger.warning("XSLT transformation failed: " + e);
                }
            } else {
                this.out.output(document, outStream);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            outStream.close();
            throw throwable;
        }
        outStream.close();
    }

    public void postRender() {
    }
}

