/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractChart;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.model.ModuleGrouper;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.IntegerMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.ContourDataset;
import org.jfree.data.DefaultContourDataset;
import org.jfree.ui.RectangleEdge;

public class ActivityProgressionChart
extends AbstractChart {
    private List groupNames = new ArrayList();
    private int groupCount;
    private CvsContent content;
    private ReportSettings settings;

    public ActivityProgressionChart(CvsContent content, ReportSettings settings) {
        super(settings, "progression%1.png", I18n.tr("Activity Progression%1"));
        this.content = content;
        this.settings = settings;
        this.setChart(this.createContourPlot());
        if (this.getChart() != null) {
            this.setup(true);
        }
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        ActivityProgressionChart chart = new ActivityProgressionChart(content, settings);
        return chart.getChart() != null ? new Report(new ChartReportElement(chart)) : null;
    }

    private JFreeChart createContourPlot() {
        Grouper grouper = this.settings.getGrouper(new ModuleGrouper(this.settings.getModules(this.content)));
        ContourDataset data = this.createDataset(grouper);
        if (data == null) {
            return null;
        }
        DateAxis xAxis = new DateAxis(I18n.tr("Date"));
        SymbolicAxis yAxis = new SymbolicAxis(grouper.getName(), this.groupNames.toArray(new String[0]));
        yAxis.setInverted(true);
        yAxis.setLowerMargin(0.0);
        yAxis.setUpperMargin(0.0);
        ColorBar zAxis = new ColorBar(I18n.tr("Commit Activity (%)"));
        zAxis.getAxis();
        ContourPlot plot = new ContourPlot(data, (ValueAxis)xAxis, (ValueAxis)yAxis, zAxis);
        plot.setDataAreaRatio(0.0);
        plot.setColorBarLocation(RectangleEdge.BOTTOM);
        return new JFreeChart(this.settings.getProjectName(), null, (Plot)plot, false);
    }

    private ContourDataset createDataset(Grouper grouper) {
        LinkedHashMap<Date, IntegerMap> mapByDate = new LinkedHashMap<Date, IntegerMap>();
        int max = 0;
        long diff = this.content.getLastDate().getTime() - this.content.getFirstDate().getTime();
        long day = 86400000L;
        long windowSize = Math.max(diff / 60L, 1L);
        IntegerMap commitsPerGroup = new IntegerMap();
        Iterator it = this.settings.getRevisionIterator(this.content);
        long currentDate = -1L;
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            Date date = rev.getDate();
            if (currentDate == -1L) {
                currentDate = date.getTime();
            } else if (date.getTime() > currentDate + windowSize) {
                max = Math.max(commitsPerGroup.max(), max);
                mapByDate.put(new Date(currentDate), commitsPerGroup);
                commitsPerGroup = new IntegerMap();
                int fill = (int)((date.getTime() - currentDate) / windowSize);
                if (fill > 1) {
                    mapByDate.put(new Date(currentDate + windowSize), null);
                }
                currentDate += (long)fill * windowSize;
            }
            commitsPerGroup.inc(grouper.getGroup(rev));
        }
        if (currentDate != -1L) {
            mapByDate.put(new Date(currentDate), commitsPerGroup);
            max = Math.max(commitsPerGroup.max(), max);
        }
        Iterator it3 = grouper.getGroups(this.content, this.settings);
        while (it3.hasNext()) {
            this.groupNames.add(grouper.getName(it3.next()));
        }
        this.groupCount = this.groupNames.size();
        int dateCount = mapByDate.size();
        int numValues = dateCount * this.groupCount;
        if (numValues == 0 || max == 0 || dateCount == 1) {
            return null;
        }
        Object[] oDateX = new Date[numValues];
        Object[] oDoubleY = new Double[numValues];
        Object[] oDoubleZ = new Double[numValues];
        it = mapByDate.keySet().iterator();
        int x = 0;
        while (x < dateCount) {
            if (!it.hasNext()) {
                throw new RuntimeException("Invalid date count");
            }
            Date date = (Date)it.next();
            IntegerMap map = (IntegerMap)mapByDate.get(date);
            if (map != null) {
                Iterator it2 = grouper.getGroups(this.content, this.settings);
                int y = 0;
                while (y < this.groupCount) {
                    if (!it2.hasNext()) {
                        throw new RuntimeException("Invalid group count");
                    }
                    Object group = it2.next();
                    int index = x * this.groupCount + y;
                    oDateX[index] = date;
                    oDoubleY[index] = new Double(y);
                    double value = (double)map.get(group) * 100.0 / (double)max;
                    oDoubleZ[index] = value != 0.0 ? new Double(value) : null;
                    ++y;
                }
            } else {
                int y = 0;
                while (y < this.groupCount) {
                    int index = x * this.groupCount + y;
                    oDateX[index] = date;
                    oDoubleY[index] = new Double(y);
                    ++y;
                }
            }
            ++x;
        }
        return new DefaultContourDataset(null, oDateX, oDoubleY, oDoubleZ);
    }

    public int getPreferredHeigth() {
        return 140 + this.groupCount * 24;
    }
}

