/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.model.FileGrouper;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import java.util.Iterator;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.util.IntegerMap;
import org.jdom.Content;

public class AuthorCountTable {
    public static Report generate(CvsContent content, ReportSettings settings) {
        ReportElement root = new ReportElement(settings, I18n.tr("Authors%1"));
        Grouper grouper = settings.getGrouper(new FileGrouper());
        IntegerMap filesMap = new IntegerMap();
        Iterator it = settings.getFileIterator(content);
        while (it.hasNext()) {
            CvsFile file = (CvsFile)it.next();
            if (file.isDead()) continue;
            Object group = grouper.getGroup(file);
            filesMap.addInt(group, file.getAuthors().size());
        }
        TableElement table = new TableElement(settings, new String[]{grouper.getName(), I18n.tr("Authors")});
        Iterator fIt = filesMap.iteratorSortedByValueReverse();
        int maxItems = settings.getLimit();
        int count = 0;
        while (fIt.hasNext() && count < maxItems) {
            Object group = fIt.next();
            table.addRow().addGroup(grouper, group).addInteger("count", filesMap.get(group));
            ++count;
        }
        root.addContent((Content)table);
        return new Report(root, table);
    }
}

