/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import de.berlios.statcvs.xml.output.TextElement;
import de.berlios.statcvs.xml.util.FileHelper;
import de.berlios.statcvs.xml.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.FileUtils;
import org.jdom.Content;

public class AuthorDetailsReport {
    private static final Logger logger = Logger.getLogger("de.berlios.statcvs.xml.report.AuthorDetailsReport");
    private static final String DEFAULT_PIC = "resources" + File.separator + "dummy.png";

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new AuthorInfoElement(settings, I18n.tr("Author Details")));
    }

    public static class AuthorInfoElement
    extends ReportElement {
        private URL pictureURL = null;
        private String pictureSource = null;
        private String pictureFilename = null;

        public AuthorInfoElement(ReportSettings settings, String name) {
            super(settings, name);
            if (settings.getForEachObject() instanceof Author) {
                Author author = (Author)settings.getForEachObject();
                int loc = 0;
                int locAdded = 0;
                Iterator it = author.getRevisions().iterator();
                while (it.hasNext()) {
                    CvsRevision rev = (CvsRevision)it.next();
                    loc += rev.getLinesDelta();
                    locAdded += rev.getNewLines();
                }
                TextElement text = new TextElement(settings, "authorinfo").addValue("login", author.getName(), I18n.tr("Login")).addValue("fullname", settings.getFullname(author), I18n.tr("Fullname")).addValue("revcount", author.getRevisions().size(), I18n.tr("Revisions")).addValue("loc", loc, I18n.tr("Lines of Code")).addValue("locAdded", locAdded, I18n.tr("Added Lines of Code")).addValue("locPerRevision", (double)loc / (double)author.getRevisions().size(), I18n.tr("Lines of Code per Change"));
                if (settings.getBoolean("showImages", true)) {
                    TableElement table = new TableElement(settings, null);
                    this.calculatePictureFilename(settings.getAuthorPic(author, DEFAULT_PIC));
                    table.addRow().addImage("authorPicture", this.pictureFilename).addContent(text);
                    this.addContent((Content)table);
                } else {
                    this.addContent((Content)text);
                }
            } else {
                logger.warning("This report can only be used in author-foreach environments.");
            }
        }

        private void calculatePictureFilename(String source) {
            try {
                this.pictureURL = new URL(source);
                this.pictureFilename = StringHelper.lastToken(this.pictureURL.getPath(), "/");
                if (this.pictureFilename.length() == 0) {
                    throw new MalformedURLException();
                }
                return;
            }
            catch (MalformedURLException e) {
                File file = new File(source);
                if (!file.exists() && !source.equals(DEFAULT_PIC)) {
                    logger.info(I18n.tr("Picture file {0} not found, using dummy instead.", source));
                    this.pictureSource = DEFAULT_PIC;
                }
                this.pictureSource = source;
                this.pictureFilename = FileUtils.getFilenameWithoutPath(this.pictureSource);
                return;
            }
        }

        public void saveResources(File outputPath) throws IOException {
            if (this.pictureFilename != null) {
                if (this.pictureURL != null) {
                    FileHelper.copyResource(this.pictureURL, outputPath, this.pictureFilename);
                } else if (this.pictureSource != null) {
                    FileHelper.copyResource(this.pictureSource, outputPath, this.pictureFilename);
                }
            }
        }
    }
}

