/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.model.MonthYearGrouper;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import de.berlios.statcvs.xml.output.TextElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.IntegerMap;
import org.jdom.Content;

public class AuthorOfTheMonthReport {
    public static Report generate(CvsContent content, ReportSettings settings) {
        IntegerMap activityByAuthor;
        ReportElement root = new ReportElement(settings, I18n.tr("Author of the Month"));
        MonthYearGrouper grouper = new MonthYearGrouper();
        Author dummyAuthor = null;
        LinkedHashMap<Object, IntegerMap> authorsByMonth = new LinkedHashMap<Object, IntegerMap>();
        Iterator<Object> it = content.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            Object group = ((Grouper)grouper).getGroup(rev);
            activityByAuthor = (IntegerMap)authorsByMonth.get(group);
            if (activityByAuthor == null) {
                activityByAuthor = new IntegerMap();
                authorsByMonth.put(group, activityByAuthor);
            }
            if (rev.getAuthor() == null) {
                if (dummyAuthor == null) {
                    dummyAuthor = new Author("(Unknown)");
                }
                activityByAuthor.addInt(dummyAuthor, rev.getNewLines());
                continue;
            }
            activityByAuthor.addInt(rev.getAuthor(), rev.getNewLines());
        }
        int maxItems = settings.getLimit();
        int count = 0;
        if (!(settings.getForEachObject() instanceof Author)) {
            TableElement table = new TableElement(settings, new String[]{I18n.tr("Month"), I18n.tr("Author"), I18n.tr("Score")});
            it = authorsByMonth.keySet().iterator();
            while (it.hasNext() && count < maxItems) {
                String month = (String)it.next();
                activityByAuthor = (IntegerMap)authorsByMonth.get(month);
                Iterator authIt = activityByAuthor.iteratorSortedByValueReverse();
                if (!authIt.hasNext()) continue;
                Author author = (Author)authIt.next();
                table.addRow().addString("month", month).addAuthor(author).addPercent("activity", activityByAuthor.getPercent(author));
                ++count;
            }
            root.addContent((Content)table);
        } else {
            TextElement text = new TextElement(settings, "authorofthemonth");
            TextElement.ListElement list = text.addList();
            it = authorsByMonth.keySet().iterator();
            while (it.hasNext() && count < maxItems) {
                String month = (String)it.next();
                activityByAuthor = (IntegerMap)authorsByMonth.get(month);
                Iterator authIt = activityByAuthor.iteratorSortedByValueReverse();
                if (!authIt.hasNext()) continue;
                Author author = (Author)authIt.next();
                if (!settings.getForEachObject().equals(author)) continue;
                list.addString(month);
                ++count;
            }
            if (list.getContent().size() == 0) {
                return null;
            }
            root.addContent((Content)text);
        }
        return new Report(root);
    }
}

