/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractStackedChart;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.sf.statcvs.input.CommitListBuilder;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import org.jfree.chart.plot.CategoryPlot;

public class AuthorsActivityChart
extends AbstractStackedChart {
    private static final int REMOVING = 0;
    private static final int CHANGING = 1;
    private static final int ADDING = 2;
    private List authors = new ArrayList();
    private String[] topics = new String[]{I18n.tr("removing"), I18n.tr("changing"), I18n.tr("adding")};

    public AuthorsActivityChart(CvsContent content, ReportSettings settings) {
        super(settings, "activity.png", I18n.tr("Author Activity"), null, "%");
        CategoryPlot plot = this.getChart().getCategoryPlot();
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.red);
        plot.getRenderer().setSeriesPaint(1, (Paint)Color.yellow);
        plot.getRenderer().setSeriesPaint(2, (Paint)Color.green);
        plot.getRangeAxis().setUpperBound(100.0);
        SortedSet auts = content.getAuthors();
        Iterator it = auts.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            this.authors.add(author.getName());
        }
        Collections.sort(this.authors);
        double[][] categories = new double[3][this.authors.size()];
        int j = 0;
        while (j < this.authors.size()) {
            categories[0][j] = 0.0;
            categories[1][j] = 0.0;
            categories[2][j] = 0.0;
            ++j;
        }
        Iterator revIt = settings.getRevisionIterator(content);
        CommitListBuilder commitList = new CommitListBuilder(revIt);
        List commits = commitList.createCommitList();
        Iterator commitIt = commits.iterator();
        while (commitIt.hasNext()) {
            Commit commit = (Commit)commitIt.next();
            Set commitRevList = commit.getRevisions();
            Iterator commitRevIt = commitRevList.iterator();
            int author = this.authors.indexOf(commit.getAuthor().getName());
            int linesAdded = 0;
            int linesRemoved = 0;
            while (commitRevIt.hasNext()) {
                CvsRevision revision = (CvsRevision)commitRevIt.next();
                linesAdded += revision.getNewLines();
                linesRemoved += revision.getNewLines() - revision.getReplacedLines();
            }
            if (linesAdded == linesRemoved) {
                double[] dArray = categories[1];
                int n = author;
                dArray[n] = dArray[n] + (double)linesAdded;
            }
            if (linesAdded < linesRemoved) {
                double[] dArray = categories[1];
                int n = author;
                dArray[n] = dArray[n] + (double)linesAdded;
                double[] dArray2 = categories[0];
                int n2 = author;
                dArray2[n2] = dArray2[n2] + (double)(linesRemoved - linesAdded);
            }
            if (linesAdded <= linesRemoved) continue;
            double[] dArray = categories[2];
            int n = author;
            dArray[n] = dArray[n] + (double)(linesAdded - linesRemoved);
            double[] dArray3 = categories[1];
            int n3 = author;
            dArray3[n3] = dArray3[n3] + (double)linesRemoved;
        }
        int i = 0;
        while (i < this.authors.size()) {
            double maxLines = categories[0][i] + categories[1][i] + categories[2][i];
            int k = 0;
            while (k < 3) {
                double[] dArray = categories[k];
                int n = i;
                dArray[n] = dArray[n] * (100.0 / maxLines);
                this.dataset.addValue(categories[k][i], (Comparable)((Object)this.topics[k]), (Comparable)((Object)((String)this.authors.get(i))));
                ++k;
            }
            ++i;
        }
        this.setup(true);
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new ChartReportElement(new AuthorsActivityChart(content, settings)));
    }
}

