/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractCombinedChart;
import de.berlios.statcvs.xml.model.AuthorGrouper;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class CommitActivityChart
extends AbstractCombinedChart {
    public CommitActivityChart(CvsContent content, ReportSettings settings) {
        super(settings, "commitactivity%1.png", I18n.tr("Commit Activity%1"));
        Object group;
        Grouper grouper = settings.getGrouper(new AuthorGrouper());
        HashMap<Object, XYSeries> seriesByGroup = new HashMap<Object, XYSeries>();
        XYSeries series = this.createXYSeries(grouper.getName() + " " + I18n.tr("(All)"), settings.getRevisionIterator(content));
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        this.addPlot(this.createPlot((XYDataset)dataset, series.getName()));
        Iterator it = settings.getRevisionIterator(content);
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            group = grouper.getGroup(rev);
            XYSeries groupSeries = (XYSeries)seriesByGroup.get(group);
            if (groupSeries == null) {
                groupSeries = new XYSeries(grouper.getName(group));
                seriesByGroup.put(group, groupSeries);
            }
            this.addToXYSeries(groupSeries, rev);
        }
        Iterator it2 = seriesByGroup.keySet().iterator();
        while (it2.hasNext()) {
            group = it2.next();
            dataset = new XYSeriesCollection((XYSeries)seriesByGroup.get(group));
            this.addPlot(this.createPlot((XYDataset)dataset, grouper.getName(group)));
        }
        this.setup(false);
    }

    private XYSeries createXYSeries(String title, Iterator it) {
        XYSeries series = new XYSeries(title);
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            Calendar cal = Calendar.getInstance();
            cal.setTime(rev.getDate());
            double hour = cal.get(11);
            double minutes = cal.get(12);
            cal.clear(10);
            cal.clear(11);
            cal.clear(12);
            cal.clear(13);
            cal.clear(14);
            series.add((double)cal.getTime().getTime(), hour + minutes / 60.0);
        }
        return series;
    }

    private void addToXYSeries(XYSeries series, CvsRevision rev) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(rev.getDate());
        double hour = cal.get(11);
        double minutes = cal.get(12);
        cal.clear(10);
        cal.clear(11);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        series.add((double)cal.getTime().getTime(), hour + minutes / 60.0);
    }

    public XYPlot createPlot(XYDataset dataset, String title) {
        NumberAxis valueAxis = new NumberAxis(title);
        valueAxis.setTickUnit(new NumberTickUnit(6.0, (NumberFormat)new DecimalFormat("0")));
        valueAxis.setAutoRangeIncludesZero(false);
        valueAxis.setLowerBound(0.0);
        valueAxis.setUpperBound(24.0);
        valueAxis.setLabelFont(new Font("SansSerif", 0, 9));
        return new XYPlot(dataset, null, (ValueAxis)valueAxis, (XYItemRenderer)new PointXYRenderer());
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new ChartReportElement(new CommitActivityChart(content, settings)));
    }

    public int getPreferredHeigth() {
        return 70 * (this.getPlotCount() + 1) + 110;
    }

    public class PointXYRenderer
    extends StandardXYItemRenderer {
        public PointXYRenderer() {
            super(1);
            this.setSeriesPaint(0, Color.RED);
            this.setSeriesShape(0, new Ellipse2D.Double(0.0, 0.0, 3.0, 3.0));
        }
    }
}

