/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractBarChart;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.model.HourGrouper;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import java.util.Iterator;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.IntegerMap;

public class CommitChart
extends AbstractBarChart {
    public CommitChart(CvsContent content, ReportSettings settings) {
        super(settings, "commit%1.png", I18n.tr("Activity%1"), null, I18n.tr("Commits"));
        Grouper grouper = settings.getGrouper(new HourGrouper());
        IntegerMap commitsByGroup = new IntegerMap();
        Iterator it = settings.getRevisionIterator(content);
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            commitsByGroup.addInt(grouper.getGroup(rev), 1);
        }
        Iterator it2 = settings.getBoolean("showAllGroups", true) ? grouper.getGroups(content, settings) : commitsByGroup.iteratorSortedByValueReverse();
        while (it2.hasNext()) {
            Object group = it2.next();
            this.dataset.addValue((double)commitsByGroup.get(group), (Comparable)((Object)I18n.tr("Activity")), (Comparable)((Object)grouper.getName(group)));
        }
        this.setup(false);
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new ChartReportElement(new CommitChart(content, settings)));
    }
}

