/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import java.util.Collections;
import java.util.List;
import net.sf.statcvs.input.CommitListBuilder;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import org.jdom.Content;

public class CommitLogTable {
    public static Report generate(CvsContent content, ReportSettings settings) {
        ReportElement report = new ReportElement(settings, I18n.tr("Commit Log"));
        TableElement table = new TableElement(settings, new String[]{I18n.tr("Date"), I18n.tr("Author"), I18n.tr("File/Message")});
        CommitListBuilder builder = new CommitListBuilder(settings.getRevisionIterator(content));
        List commits = builder.createCommitList();
        Collections.reverse(commits);
        int maxItems = settings.getLimit();
        int i = 0;
        while (i < commits.size() && i < maxItems) {
            Commit commit = (Commit)commits.get(i);
            TableElement.RowElement row = table.addRow();
            row.addDate("date", commit.getDate());
            row.addAuthor(commit.getAuthor());
            row.addCommit(commit);
            ++i;
        }
        report.addContent((Content)table);
        return new Report(report, table);
    }
}

