/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.model.AuthorGrouper;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import java.util.Iterator;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.IntegerMap;
import org.jdom.Content;

public class CommitTable {
    public static Report generate(CvsContent content, ReportSettings settings) {
        ReportElement root = new ReportElement(settings, I18n.tr("Commits%1"));
        Grouper grouper = settings.getGrouper(new AuthorGrouper());
        IntegerMap changesMap = new IntegerMap();
        IntegerMap linesMap = new IntegerMap();
        IntegerMap linesAddedMap = new IntegerMap();
        Iterator revIt = settings.getRevisionIterator(content);
        while (revIt.hasNext()) {
            CvsRevision rev = (CvsRevision)revIt.next();
            Object group = grouper.getGroup(rev);
            if (group == null) continue;
            changesMap.addInt(group, 1);
            linesMap.addInt(group, rev.getLinesDelta());
            linesAddedMap.addInt(group, rev.getNewLines());
        }
        TableElement table = new TableElement(settings, new String[]{grouper.getName(), I18n.tr("Revisions"), I18n.tr("Lines of Code"), I18n.tr("Added Lines of Code"), I18n.tr("Lines of Code per Change")});
        int maxItems = settings.getLimit();
        String orderby = settings.getString("orderby");
        Iterator it = "loc".equals(orderby) ? linesMap.iteratorSortedByValueReverse() : changesMap.iteratorSortedByValueReverse();
        int count = 0;
        while (it.hasNext() && count < maxItems) {
            Object group = it.next();
            table.addRow().addGroup(grouper, group).addInteger("revisions", changesMap.get(group), changesMap.getPercent(group)).addInteger("loc", linesMap.get(group), linesMap.getPercent(group)).addInteger("locAdded", linesAddedMap.get(group), linesAddedMap.getPercent(group)).addDouble("locPerRevision", (double)linesMap.get(group) / (double)changesMap.get(group));
            ++count;
        }
        root.addContent((Content)table);
        return new Report(root, table);
    }
}

