/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import de.berlios.statcvs.xml.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.Directory;
import org.jdom.Content;

public class DirectoryTree {
    public static Report generate(CvsContent content, ReportSettings settings) {
        DirectoryTreeElement root = new DirectoryTreeElement(settings, I18n.tr("Repository Tree"));
        Iterator it = settings.getDirectoryIterator(content);
        TableElement table = new TableElement(settings, new String[]{I18n.tr("Directory"), I18n.tr("Files"), I18n.tr("Lines of Code")});
        int rootDepth = 0;
        boolean firstProcessed = false;
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            if (!firstProcessed) {
                rootDepth = dir.getDepth();
                firstProcessed = true;
            }
            table.addRow().addDirectoryTree(dir, dir.getDepth() - rootDepth).addInteger("files", dir.getCurrentFileCount()).addInteger("loc", dir.getCurrentLOC());
        }
        root.addContent((Content)table);
        return new Report(root, table);
    }

    public static class DirectoryTreeElement
    extends ReportElement {
        public DirectoryTreeElement(ReportSettings settings, String name) {
            super(settings, name);
        }

        public void saveResources(File outputPath) throws IOException {
            FileHelper.copyResource("resources/folder.png", outputPath);
            FileHelper.copyResource("resources/folder-deleted.png", outputPath);
            FileHelper.copyResource("resources/folder-open.png", outputPath);
        }
    }
}

