/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractChart;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TooltipMapElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.SymbolicName;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;

public class EvolutionMatrixChart
extends AbstractChart {
    private final int SPACER = 25;
    private final int LINE_HEIGHT = 4;
    private final int TEXT_HEIGHT = 15;
    private TooltipMapElement tooltipMap = new TooltipMapElement("evomatrix");

    public EvolutionMatrixChart(CvsContent content, ReportSettings settings) {
        super(settings, "evolution.png", I18n.tr("Software Evolution Matrix"));
        this.setChart(new JFreeChart(settings.getProjectName(), null, (Plot)new EvolutionMatrixPlot(content, settings), true));
        this.setup(true);
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        EvolutionMatrixChart chart = new EvolutionMatrixChart(content, settings);
        return chart.getChart() != null ? new Report(new ChartReportElement(chart, chart.getTooltipMap())) : null;
    }

    private TooltipMapElement getTooltipMap() {
        return this.tooltipMap;
    }

    public int getPreferredHeigth() {
        if (this.getChart() == null) {
            return super.getPreferredHeigth();
        }
        return ((EvolutionMatrixPlot)this.getChart().getPlot()).getHeight();
    }

    private class TaggedFile {
        private Map revisionByVersion = new TreeMap();
        private CvsFile file;

        public TaggedFile(CvsFile file) {
            this.file = file;
        }

        void addRevision(Version ver, CvsRevision rev) {
            this.revisionByVersion.put(ver, rev);
        }

        public CvsRevision getRevision(Version ver) {
            if (ver == null) {
                return null;
            }
            return (CvsRevision)this.revisionByVersion.get(ver);
        }

        public double getScore(Version ver) {
            if (ver.getMaxLoc() != 0) {
                return (double)this.getRevision(ver).getLines() / (double)ver.getMaxLoc();
            }
            return 0.0;
        }

        public double getChangedScore(Version oldV, Version thisV) {
            CvsRevision target = this.getRevision(oldV);
            CvsRevision curr = this.getRevision(thisV);
            double change = curr.getReplacedLines();
            int revCount = 0;
            while (target != curr && curr != null) {
                if ((curr = curr.getPreviousRevision()) == null || curr.getLines() == 0) continue;
                change += (double)(curr.getReplacedLines() / curr.getLines());
                ++revCount;
            }
            if (this.getRevision(thisV).getLines() != 0) {
                return change / (double)this.getRevision(thisV).getLines();
            }
            return change == 0.0 ? 0.0 : 1.0;
        }

        public boolean isInVersion(Version ver) {
            return this.getRevision(ver) != null;
        }

        public boolean hasSameRevision(Version v1, Version v2) {
            return this.getRevision(v1) == this.getRevision(v2) && this.getRevision(v1) != null;
        }
    }

    private class Version
    implements Comparable {
        private String name;
        private Date date;
        private int maxLoc;

        public Version(String name, Date date) {
            this.date = date;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Date getDate() {
            return this.date;
        }

        public int getMaxLoc() {
            return this.maxLoc;
        }

        public void setMaxLoc(int maxLoc) {
            this.maxLoc = maxLoc;
        }

        public int compareTo(Object o) {
            Version other = (Version)o;
            int dateComp = this.getDate().compareTo(other.getDate());
            return dateComp != 0 ? dateComp : this.getName().compareTo(other.getName());
        }

        public boolean equals(Object obj) {
            return (this.name + this.date).equals(obj);
        }

        public int hashCode() {
            return (this.name + this.date).hashCode();
        }
    }

    private class EvolutionMatrixPlot
    extends Plot {
        private CvsContent content;
        private Map filesByVersion = new TreeMap();
        private Map evoFiles = new HashMap();
        private SortedSet versions = new TreeSet();

        public EvolutionMatrixPlot(CvsContent content, ReportSettings settings) {
            this.content = content;
            Iterator it = settings.getSymbolicNameIterator(content);
            while (it.hasNext()) {
                SymbolicName sn = (SymbolicName)it.next();
                Version version = new Version(sn.getName(), sn.getDate());
                int maxLoc = 0;
                Iterator revIt = sn.getRevisions().iterator();
                while (revIt.hasNext()) {
                    CvsRevision rev = (CvsRevision)revIt.next();
                    maxLoc = Math.max(maxLoc, rev.getLines());
                    TaggedFile evo = (TaggedFile)this.evoFiles.get(rev.getFile());
                    if (evo == null) {
                        evo = new TaggedFile(rev.getFile());
                        this.evoFiles.put(rev.getFile(), evo);
                    }
                    evo.addRevision(version, rev);
                }
                version.setMaxLoc(maxLoc);
                this.versions.add(version);
            }
            Version version = new Version("HEAD", new Date());
            it = content.getFiles().iterator();
            int maxLoc = 0;
            while (it.hasNext()) {
                CvsFile file = (CvsFile)it.next();
                if (file.isDead()) continue;
                TaggedFile evo = (TaggedFile)this.evoFiles.get(file);
                if (evo == null) {
                    evo = new TaggedFile(file);
                    this.evoFiles.put(file, evo);
                }
                maxLoc = Math.max(maxLoc, file.getLatestRevision().getLines());
                evo.addRevision(version, file.getLatestRevision());
            }
            version.setMaxLoc(maxLoc);
            this.versions.add(version);
        }

        public String getPlotType() {
            return "EvolutionMatrixPlot";
        }

        public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState state, PlotRenderingInfo info) {
            Insets insets;
            if (info != null) {
                info.setPlotArea(plotArea);
            }
            if ((insets = this.getInsets()) != null) {
                plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
            }
            ArrayList newAdded = new ArrayList();
            Iterator verIt = this.versions.iterator();
            double vspace = plotArea.getWidth() / (double)this.versions.size();
            double x = plotArea.getX();
            double y = plotArea.getY() + 25.0;
            Stroke oldStroke = g2.getStroke();
            BasicStroke itemStroke = new BasicStroke(1.0f);
            BasicStroke borderStroke = new BasicStroke(1.0f);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Version lastVersion = null;
            while (verIt.hasNext()) {
                Version ver = (Version)verIt.next();
                g2.setColor(Color.black);
                g2.drawString(ver.getName(), (int)x, (int)plotArea.getY() + 25 - 10);
                Iterator dirIt = this.content.getDirectories().iterator();
                while (dirIt.hasNext()) {
                    Directory dir = (Directory)dirIt.next();
                    Iterator fit = dir.getFiles().iterator();
                    if (dir.getFiles().size() != 0) {
                        y += 8.0;
                        if (x == plotArea.getX()) {
                            g2.setColor(new Color(0xCCCCCC));
                            g2.setStroke(borderStroke);
                            Rectangle2D r = g2.getFontMetrics().getStringBounds(dir.getName(), g2);
                            g2.fill3DRect((int)x - 3, (int)(y + r.getY() + 1.0), (int)plotArea.getWidth(), (int)r.getHeight(), true);
                            g2.setColor(Color.black);
                            g2.drawString(dir.getPath(), (float)x, (float)y);
                        }
                        y += 4.0;
                    }
                    while (fit.hasNext()) {
                        CvsRevision linkRev;
                        CvsFile file = (CvsFile)fit.next();
                        TaggedFile eFile = (TaggedFile)this.evoFiles.get(file);
                        g2.setStroke(itemStroke);
                        g2.setColor(Color.lightGray);
                        this.drawLine(g2, plotArea, x - 1.0, y, 0, 4);
                        if (eFile != null) {
                            int length;
                            if (lastVersion != null) {
                                if (!eFile.isInVersion(lastVersion)) {
                                    g2.setColor(Color.green);
                                } else if (eFile.hasSameRevision(lastVersion, ver)) {
                                    g2.setColor(Color.gray);
                                } else if (!eFile.isInVersion(ver) && eFile.isInVersion(lastVersion)) {
                                    g2.setColor(Color.black);
                                } else {
                                    g2.setColor(Color.red);
                                }
                            } else {
                                g2.setColor(Color.green);
                            }
                            if (eFile.isInVersion(ver)) {
                                length = (int)(eFile.getScore(ver) * (vspace - 10.0));
                                this.drawLine(g2, plotArea, x, y, length, 4);
                            } else if (eFile.isInVersion(lastVersion)) {
                                int length2 = (int)(eFile.getScore(lastVersion) * (vspace - 10.0));
                                this.drawLine(g2, plotArea, x, y, length2, 4);
                            }
                            if (lastVersion != null && eFile.getRevision(ver) != null && eFile.getRevision(lastVersion) != null && !eFile.hasSameRevision(lastVersion, ver)) {
                                g2.setColor(Color.yellow);
                                length = (int)(eFile.getChangedScore(lastVersion, ver) * (vspace - 10.0));
                                this.drawLine(g2, plotArea, x, y, length, 4);
                            }
                        }
                        CvsRevision cvsRevision = linkRev = eFile == null ? null : eFile.getRevision(ver);
                        String link = EvolutionMatrixChart.this.getSettings().getWebRepository() == null ? "#" : (linkRev == null ? EvolutionMatrixChart.this.getSettings().getWebRepository().getFileHistoryUrl(file) : EvolutionMatrixChart.this.getSettings().getWebRepository().getFileViewUrl(eFile.getRevision(ver)));
                        EvolutionMatrixChart.this.tooltipMap.addRectArea((int)x, (int)y, (int)(x + vspace), (int)y + 4, file.getFilenameWithPath(), link);
                        y += 5.0;
                    }
                }
                x += vspace;
                y = plotArea.getY() + 25.0;
                lastVersion = ver;
            }
            g2.setStroke(oldStroke);
        }

        private void drawLine(Graphics2D g2, Rectangle2D plotArea, double x, double y, int length, int width) {
            int i = 0;
            while (i < width) {
                g2.drawLine((int)x, (int)y + i, (int)x + length, (int)y + i);
                ++i;
            }
        }

        public int getHeight() {
            int dirCount = 0;
            Iterator it = this.content.getDirectories().iterator();
            while (it.hasNext()) {
                if (((Directory)it.next()).getFiles().size() == 0) continue;
                ++dirCount;
            }
            return this.getInsets().bottom + this.getInsets().bottom + 100 + this.content.getFiles().size() * 5 + dirCount * 15;
        }

        public LegendItemCollection getLegendItems() {
            LegendItemCollection result = new LegendItemCollection();
            BasicStroke stroke = new BasicStroke(1.0f);
            LegendItem le = new LegendItem(I18n.tr("Added File"), "", null, true, (Paint)Color.green, (Stroke)stroke, (Paint)Color.black, (Stroke)stroke);
            result.add(le);
            le = new LegendItem(I18n.tr("Modified File"), "", null, true, (Paint)Color.red, (Stroke)stroke, (Paint)Color.black, (Stroke)stroke);
            result.add(le);
            le = new LegendItem(I18n.tr("Unmodified File"), "", null, true, (Paint)Color.gray, (Stroke)stroke, (Paint)Color.black, (Stroke)stroke);
            result.add(le);
            le = new LegendItem(I18n.tr("Removed File"), "", null, true, (Paint)Color.black, (Stroke)stroke, (Paint)Color.black, (Stroke)stroke);
            result.add(le);
            le = new LegendItem(I18n.tr("Changes"), "", null, true, (Paint)Color.yellow, (Stroke)stroke, (Paint)Color.black, (Stroke)stroke);
            result.add(le);
            return result;
        }
    }
}

