/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractTimeSeriesChart;
import de.berlios.statcvs.xml.chart.RevisionVisitor;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;

public class FileCountChart
extends AbstractTimeSeriesChart {
    public FileCountChart(CvsContent content, ReportSettings settings) {
        super(settings, "file_count.png", I18n.tr("File Count"), I18n.tr("Files"));
        this.addTimeSeries(this.createTimeSeries(I18n.tr("File Count"), settings.getRevisionIterator(content), new Calculator()), content.getFirstDate(), 0);
        this.setup(false);
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new ChartReportElement(new FileCountChart(content, settings)));
    }

    public static class Calculator
    implements RevisionVisitor {
        int fileCount = 0;

        public int visit(CvsRevision rev) {
            this.fileCount += rev.getFileCountDelta();
            return this.fileCount;
        }
    }
}

