/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.report.LocChart;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Iterator;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;

public class LocByAuthorChart
extends LocChart {
    private CvsContent content;

    public LocByAuthorChart(CvsContent content, ReportSettings settings) {
        super(content, settings, I18n.tr("Lines Of Code (per Author)"));
        Object highlightAuthor = settings.getForEachObject();
        int i = 0;
        Iterator it = content.getAuthors().iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            this.addTimeSeries(settings.getFullname(author), author.getRevisions().iterator());
            if (author == highlightAuthor) {
                this.getChart().getXYPlot().getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(2.0f, 0, 0));
            }
            ++i;
        }
        this.addSymbolicNames(settings.getSymbolicNameIterator(content));
        this.setup(true);
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new ChartReportElement(new LocByAuthorChart(content, settings)));
    }
}

