/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.model.CommitCommentGrouper;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportElement;
import de.berlios.statcvs.xml.output.ReportSettings;
import de.berlios.statcvs.xml.output.TableElement;
import java.util.Iterator;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.util.IntegerMap;
import org.jdom.Content;

public class MostCommonCommentsTable {
    public static Report generate(CvsContent content, ReportSettings settings) {
        ReportElement root = new ReportElement(settings, I18n.tr("Most Common Commit Comments"));
        CommitCommentGrouper grouper = new CommitCommentGrouper();
        IntegerMap commentFrequency = new IntegerMap();
        Iterator commIt = content.getCommits().iterator();
        while (commIt.hasNext()) {
            Commit commit = (Commit)commIt.next();
            commentFrequency.inc(((Grouper)grouper).getGroup(commit));
        }
        TableElement table = new TableElement(settings, new String[]{I18n.tr("Comment"), I18n.tr("Frequency")});
        Iterator it = commentFrequency.iteratorSortedByValueReverse();
        int maxItems = settings.getLimit();
        int count = 0;
        while (it.hasNext() && count < maxItems) {
            String comment = (String)it.next();
            table.addRow().addString("comment", comment).addInteger("frequency", commentFrequency.get(comment), commentFrequency.getPercent(comment));
            ++count;
        }
        root.addContent((Content)table);
        return new Report(root);
    }
}

