/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.report;

import de.berlios.statcvs.xml.I18n;
import de.berlios.statcvs.xml.chart.AbstractPieChart;
import de.berlios.statcvs.xml.model.DirectoryGrouper;
import de.berlios.statcvs.xml.model.Grouper;
import de.berlios.statcvs.xml.output.ChartReportElement;
import de.berlios.statcvs.xml.output.Report;
import de.berlios.statcvs.xml.output.ReportSettings;
import java.util.Iterator;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.IntegerMap;

public class SizeChart
extends AbstractPieChart {
    public SizeChart(CvsContent content, ReportSettings settings) {
        super(settings, "size%1.png", I18n.tr("Lines Of Code%1"));
        Grouper grouper = settings.getGrouper(new DirectoryGrouper());
        IntegerMap sizeByGroup = new IntegerMap();
        Iterator it = settings.getRevisionIterator(content);
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            sizeByGroup.addInt(grouper.getGroup(rev), rev.getLinesDelta());
        }
        this.setValues(sizeByGroup, settings.getInt("sliceMinValue", 5), grouper);
        this.setup(true);
    }

    private void setValues(IntegerMap sizeByGroup, int sliceMinValue, Grouper grouper) {
        Object otherGroup = grouper.getOtherGroup();
        int otherSize = otherGroup != null ? sizeByGroup.get(otherGroup) : 0;
        Iterator it = sizeByGroup.iteratorSortedByValue();
        while (it.hasNext()) {
            Object group = it.next();
            if (group == otherGroup) continue;
            if (sizeByGroup.getPercent(group) >= (double)sliceMinValue) {
                this.dataset.setValue((Comparable)((Object)grouper.getName(group)), (Number)sizeByGroup.getInteger(group));
                continue;
            }
            otherSize += sizeByGroup.get(group);
        }
        if (otherSize > 0) {
            this.dataset.setValue((Comparable)((Object)(otherGroup != null ? grouper.getName(otherGroup) : I18n.tr("Other"))), (Number)new Integer(otherSize));
        }
    }

    public static Report generate(CvsContent content, ReportSettings settings) {
        return new Report(new ChartReportElement(new SizeChart(content, settings)));
    }
}

