/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CvsLogMerger {
    public static final String FILE_BLOCK_PREFIX = "RCS file: ";
    public static final String REVISION_DELIMITER = "----------------------------";
    public static final String FILE_DELIMITER = "=============================================================================";
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss zzz";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private static SimpleDateFormat logTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz", LOG_TIMESTAMP_LOCALE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("usage: java de.berlios.statcvs.xml.util.CvsLogMerger oldfile newfile");
            System.exit(1);
        }
        try {
            BufferedReader inOld = new BufferedReader(new FileReader(args[0]));
            try {
                BufferedReader inNew = new BufferedReader(new FileReader(args[1]));
                try {
                    CvsLogMerger.merge(inOld, inNew);
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    inNew.close();
                    throw throwable;
                }
                inNew.close();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                inOld.close();
                throw throwable;
            }
            inOld.close();
            {
            }
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void merge(BufferedReader inOld, BufferedReader inNew) throws IOException {
        String line;
        String cvsFilename = null;
        Date lastRevisionDate = null;
        while ((line = inNew.readLine()) != null) {
            void var4_4;
            if (var4_4.startsWith(FILE_BLOCK_PREFIX)) {
                cvsFilename = var4_4.substring(FILE_BLOCK_PREFIX.length());
            } else if (var4_4.startsWith(REVISION_DELIMITER)) {
                CvsLogMerger.println((String)var4_4);
                CvsLogMerger.println(inNew.readLine());
                line = inNew.readLine();
                if (line != null) {
                    lastRevisionDate = CvsLogMerger.convertFromLogTime(line);
                }
            } else if (line.equals(FILE_DELIMITER)) {
                CvsLogMerger.copyThrough(inOld, cvsFilename, lastRevisionDate);
                cvsFilename = null;
                lastRevisionDate = null;
            }
            CvsLogMerger.println(line);
        }
    }

    private static Date convertFromLogTime(String line) throws IOException {
        int endOfDateIndex = line.indexOf(59, 6);
        String dateString = line.substring(6, endOfDateIndex) + " GMT";
        try {
            return logTimeFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new IOException("Invalid date format: " + dateString);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void copyThrough(BufferedReader in, String cvsFilename, Date lastDate) throws IOException {
        String line;
        int state = 1;
        while ((line = in.readLine()) != null && state == 1) {
            void var4_4;
            if (!var4_4.startsWith(FILE_BLOCK_PREFIX) || !cvsFilename.equals(var4_4.substring(FILE_BLOCK_PREFIX.length()))) continue;
            state = 2;
        }
        if (state == 2 && lastDate != null) {
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null && state == 2) {
                if (!line.startsWith(REVISION_DELIMITER)) continue;
                sb.append(line + "\n");
                sb.append(in.readLine() + "\n");
                line = in.readLine();
                sb.append(line);
                Date date = CvsLogMerger.convertFromLogTime(line);
                if (date.getTime() <= lastDate.getTime()) continue;
                CvsLogMerger.println(sb.toString());
                state = 3;
            }
        }
        while ((line = in.readLine()) != null && state == 2) {
            if (line.startsWith(FILE_DELIMITER)) {
                return;
            }
            CvsLogMerger.println(line);
        }
    }

    private static void println(String line) throws IOException {
        if (line == null) {
            throw new IOException("Unexpected end of file");
        }
        System.out.println(line);
    }
}

