/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.util;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;

public class Formatter {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final String[] SIZES = new String[]{"B", "KB", "MB", "GB", "TB"};

    public static String formatNumber(double number, int decimal) {
        NumberFormat n = NumberFormat.getNumberInstance();
        if (decimal > 0) {
            n.setMinimumFractionDigits(decimal);
            n.setMaximumFractionDigits(decimal);
        }
        return n.format(number);
    }

    public static String formatNumber(double number) {
        return Formatter.formatNumber(number, 0);
    }

    public static String formatPercent(double number) {
        NumberFormat n = NumberFormat.getPercentInstance();
        n.setMinimumFractionDigits(1);
        n.setMaximumFractionDigits(1);
        return n.format(number);
    }

    public static String formatSize(double size) {
        int i = 0;
        while (i < SIZES.length - 1 && size >= 1024.0) {
            size /= 1024.0;
            ++i;
        }
        return Formatter.formatNumber(size, 1) + " " + SIZES[i];
    }

    public static String formatLength(long i) {
        StringBuffer s = new StringBuffer();
        long x = i / 3600L;
        if (x > 0L) {
            s.append(x);
            s.append(":");
        }
        if ((x = i % 3600L / 60L) < 10L) {
            s.append("0");
        }
        s.append(x);
        s.append(":");
        x = i % 60L;
        if (x < 10L) {
            s.append("0");
        }
        s.append(x);
        return s.toString();
    }

    public static String formatDate(Date date) {
        return DateFormat.getInstance().format(date);
    }
}

