/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.statcvs.xml.util;

public class StringHelper {
    public static String escapeFilename(String filename) {
        if (filename.endsWith("/")) {
            filename = filename.substring(0, filename.length() - 1);
        }
        filename = filename.replaceAll("/", "_");
        filename = filename.replaceAll("#", "_");
        return filename;
    }

    public static String replaceNonXMLCharacters(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(text);
        int i = 0;
        int len = text.length();
        while (i < len) {
            if (!StringHelper.isXMLCharacter(text.charAt(i))) {
                sb.setCharAt(i, '?');
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isXMLCharacter(char c) {
        if (c == '\n') {
            return true;
        }
        if (c == '\r') {
            return true;
        }
        if (c == '\t') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        if (c <= '\ufffd') {
            return true;
        }
        if (c < '\u10000') {
            return false;
        }
        return c <= '\u10ffff';
    }

    public static String lastToken(String text, String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("separator must not be null");
        }
        if (separator.length() == 0) {
            throw new IllegalArgumentException("separator must not be empty");
        }
        int i = text.lastIndexOf(separator);
        if (i == -1) {
            return text;
        }
        if (i == text.length() - 1) {
            return "";
        }
        return text.substring(i + separator.length(), text.length());
    }
}

