/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.CvsRevisionParser;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.util.CvsLogUtils;
import net.sf.statcvs.util.LookaheadReader;

public class CvsFileBlockParser {
    private static Logger logger = Logger.getLogger((class$net$sf$statcvs$input$CvsFileBlockParser == null ? (class$net$sf$statcvs$input$CvsFileBlockParser = CvsFileBlockParser.class$("net.sf.statcvs.input.CvsFileBlockParser")) : class$net$sf$statcvs$input$CvsFileBlockParser).getName());
    private LookaheadReader logReader;
    private CvsLogBuilder builder;
    private boolean isLogWithoutSymbolicNames = false;
    private boolean isFirstFile;
    private Map revBySymNames = new HashMap();
    static /* synthetic */ Class class$net$sf$statcvs$input$CvsFileBlockParser;

    public CvsFileBlockParser(LookaheadReader logReader, CvsLogBuilder builder, boolean isFirstFile) {
        this.logReader = logReader;
        this.builder = builder;
        this.isFirstFile = isFirstFile;
    }

    public void parse() throws LogSyntaxException, IOException {
        String rcsFile = this.parseSingleLine(this.logReader.getCurrentLine(), "RCS file: ");
        String workingFile = this.parseSingleLine(this.logReader.getNextLine(), "Working file: ");
        boolean isInAttic = CvsLogUtils.isInAttic(rcsFile, workingFile);
        this.requireLine(this.logReader.getNextLine(), "head:");
        this.requireLine(this.logReader.getNextLine(), "branch:");
        this.requireLine(this.logReader.getNextLine(), "locks:");
        this.parseLocksAndAccessList();
        this.parseSymbolicNames();
        String keywordSubst = this.parseSingleLine(this.logReader.getCurrentLine(), "keyword substitution: ");
        boolean isBinary = false;
        try {
            isBinary = CvsLogUtils.isBinaryKeywordSubst(keywordSubst);
        }
        catch (IllegalArgumentException unknownKeywordSubst) {
            logger.warning("unknown keyword substitution '" + keywordSubst + "' in line " + this.logReader.getLineNumber());
        }
        this.requireLine(this.logReader.getNextLine(), "total revisions:");
        this.parseDescription();
        if (this.isFirstFile) {
            this.builder.buildModule(CvsLogUtils.getModuleName(rcsFile, workingFile));
        }
        this.builder.buildFile(workingFile, isBinary, isInAttic, this.revBySymNames);
        if ("=============================================================================".equals(this.logReader.getCurrentLine())) {
            this.logReader.getNextLine();
        } else {
            new CvsRevisionParser(this.logReader, this.builder).parse();
        }
    }

    public boolean isLogWithoutSymbolicNames() {
        return this.isLogWithoutSymbolicNames;
    }

    private String parseSingleLine(String line, String lineStart) throws IOException, LogSyntaxException {
        if (!line.startsWith(lineStart)) {
            throw new LogSyntaxException("line " + this.logReader.getLineNumber() + ": expected '" + lineStart + "' but found '" + line + "'");
        }
        return line.substring(lineStart.length());
    }

    private void requireLine(String line, String lineStart) throws IOException, LogSyntaxException {
        this.parseSingleLine(line, lineStart);
    }

    private void parseSymbolicNames() throws IOException, LogSyntaxException {
        String line;
        if (this.logReader.getCurrentLine().equals("symbolic names:")) {
            line = this.logReader.getNextLine();
        } else {
            this.isLogWithoutSymbolicNames = true;
            line = this.logReader.getCurrentLine();
        }
        while (line != null && !line.startsWith("keyword substitution: ")) {
            int firstColon = line.indexOf(58);
            String tagName = line.substring(1, firstColon);
            String tagRevision = line.substring(firstColon + 2);
            this.revBySymNames.put(tagName, tagRevision);
            line = this.logReader.getNextLine();
        }
    }

    private void parseLocksAndAccessList() throws IOException, LogSyntaxException {
        String line;
        while ((line = this.logReader.getNextLine()) != null && !line.equals("access list:")) {
        }
        while ((line = this.logReader.getNextLine()) != null && !line.equals("symbolic names:") && !line.startsWith("keyword substitution: ")) {
        }
    }

    private void parseDescription() throws LogSyntaxException, IOException {
        String line = this.logReader.getNextLine();
        if (line.equals("=============================================================================")) {
            throw new LogSyntaxException("line " + this.logReader.getLineNumber() + ": missing description; please don't use the -h switch of 'cvs log'!");
        }
        this.requireLine(this.logReader.getCurrentLine(), "description:");
        while (!this.isDescriptionDelimiter(this.logReader.getCurrentLine())) {
            this.logReader.getNextLine();
        }
    }

    private boolean isDescriptionDelimiter(String line) {
        return "----------------------------".equals(line) || "=============================================================================".equals(line);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

