/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.sf.statcvs.input.Builder;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.input.RevisionData;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.SymbolicName;

public class FileBuilder {
    private static Logger logger = Logger.getLogger((class$net$sf$statcvs$input$FileBuilder == null ? (class$net$sf$statcvs$input$FileBuilder = FileBuilder.class$("net.sf.statcvs.input.FileBuilder")) : class$net$sf$statcvs$input$FileBuilder).getName());
    private Builder builder;
    private String name;
    private boolean isBinary;
    private List revisions = new ArrayList();
    private RevisionData lastAdded = null;
    private Map revBySymnames;
    private int locDelta;
    static /* synthetic */ Class class$net$sf$statcvs$input$FileBuilder;

    public FileBuilder(Builder builder, String name, boolean isBinary, Map revBySymnames) {
        this.builder = builder;
        this.name = name;
        this.isBinary = isBinary;
        this.revBySymnames = revBySymnames;
        logger.fine("logging " + name);
    }

    public void addRevisionData(RevisionData data) {
        if (!data.isOnTrunk()) {
            return;
        }
        if (this.isBinary && !data.isCreation()) {
            data.setLines(0, 0);
        }
        this.revisions.add(data);
        this.lastAdded = data;
        this.locDelta += this.getLOCChange(data);
    }

    public CvsFile createFile(Date beginOfLogDate) {
        SortedSet symbolicNames;
        if (this.isFilteredFile() || !this.fileExistsInLogPeriod()) {
            return null;
        }
        if (this.revisions.size() == 1 && this.lastAdded.isAddOnSubbranch()) {
            return null;
        }
        CvsFile file = new CvsFile(this.name, this.builder.getDirectory(this.name));
        if (this.revisions.isEmpty()) {
            this.buildBeginOfLogRevision(file, beginOfLogDate, this.getFinalLOC(), null);
            return file;
        }
        Iterator it = this.revisions.iterator();
        RevisionData currentData = (RevisionData)it.next();
        int currentLOC = this.getFinalLOC();
        while (it.hasNext()) {
            RevisionData previousData = currentData;
            int previousLOC = currentLOC;
            currentData = (RevisionData)it.next();
            currentLOC = previousLOC - this.getLOCChange(previousData);
            symbolicNames = this.createSymbolicNamesCollection(previousData);
            if (previousData.isChangeOrRestore()) {
                if (currentData.isDeletion() || currentData.isAddOnSubbranch()) {
                    this.buildCreationRevision(file, previousData, previousLOC, symbolicNames);
                    continue;
                }
                this.buildChangeRevision(file, previousData, previousLOC, symbolicNames);
                continue;
            }
            if (previousData.isDeletion()) {
                this.buildDeletionRevision(file, previousData, previousLOC, symbolicNames);
                continue;
            }
            logger.warning("illegal state in " + file.getFilenameWithPath() + ":" + previousData.getRevisionNumber());
        }
        symbolicNames = this.createSymbolicNamesCollection(currentData);
        int nextLinesOfCode = currentLOC - this.getLOCChange(currentData);
        if (currentData.isCreation()) {
            this.buildCreationRevision(file, currentData, currentLOC, symbolicNames);
        } else if (currentData.isDeletion()) {
            this.buildDeletionRevision(file, currentData, currentLOC, symbolicNames);
            this.buildBeginOfLogRevision(file, beginOfLogDate, nextLinesOfCode, symbolicNames);
        } else if (currentData.isChangeOrRestore()) {
            this.buildChangeRevision(file, currentData, currentLOC, symbolicNames);
            this.buildBeginOfLogRevision(file, beginOfLogDate, nextLinesOfCode, symbolicNames);
        } else if (!currentData.isAddOnSubbranch()) {
            logger.warning("illegal state in " + file.getFilenameWithPath() + ":" + currentData.getRevisionNumber());
        }
        return file;
    }

    private int getFinalLOC() {
        String revision;
        block10: {
            if (this.isBinary) {
                return 0;
            }
            if (this.lastAdded != null && this.lastAdded.isAddOnSubbranch()) {
                return this.locDelta;
            }
            revision = null;
            try {
                revision = this.builder.getRevision(this.name);
            }
            catch (IOException e) {
                if (this.finalRevisionIsDead()) break block10;
                logger.warning(e.getMessage());
            }
        }
        try {
            if ("1.1".equals(revision)) {
                return this.builder.getLOC(this.name) + this.locDelta;
            }
            if (!this.revisions.isEmpty()) {
                RevisionData firstAdded = (RevisionData)this.revisions.get(0);
                if (!this.finalRevisionIsDead() && !firstAdded.getRevisionNumber().equals(revision)) {
                    logger.warning("Revision of " + this.name + " does not match expected revision");
                }
            }
            return this.builder.getLOC(this.name);
        }
        catch (NoLineCountException e) {
            if (!this.finalRevisionIsDead()) {
                logger.warning(e.getMessage());
            }
            return this.approximateFinalLOC();
        }
    }

    private boolean finalRevisionIsDead() {
        if (this.revisions.isEmpty()) {
            return false;
        }
        return ((RevisionData)this.revisions.get(0)).isDeletion();
    }

    private int approximateFinalLOC() {
        int max = 0;
        int current = 0;
        Iterator it = this.revisions.iterator();
        while (it.hasNext()) {
            RevisionData data = (RevisionData)it.next();
            max = Math.max(current += data.getLinesAdded(), max);
            current -= data.getLinesRemoved();
        }
        return max;
    }

    private int getLOCChange(RevisionData data) {
        return data.getLinesAdded() - data.getLinesRemoved();
    }

    private void buildCreationRevision(CvsFile file, RevisionData data, int loc, SortedSet symbolicNames) {
        file.addInitialRevision(data.getRevisionNumber(), this.builder.getAuthor(data.getLoginName()), data.getDate(), data.getComment(), loc, symbolicNames);
    }

    private void buildChangeRevision(CvsFile file, RevisionData data, int loc, SortedSet symbolicNames) {
        file.addChangeRevision(data.getRevisionNumber(), this.builder.getAuthor(data.getLoginName()), data.getDate(), data.getComment(), loc, data.getLinesAdded() - data.getLinesRemoved(), Math.min(data.getLinesAdded(), data.getLinesRemoved()), symbolicNames);
    }

    private void buildDeletionRevision(CvsFile file, RevisionData data, int loc, SortedSet symbolicNames) {
        file.addDeletionRevision(data.getRevisionNumber(), this.builder.getAuthor(data.getLoginName()), data.getDate(), data.getComment(), loc, symbolicNames);
    }

    private void buildBeginOfLogRevision(CvsFile file, Date beginOfLogDate, int loc, SortedSet symbolicNames) {
        Date date = new Date(beginOfLogDate.getTime() - 60000L);
        file.addBeginOfLogRevision(date, loc, symbolicNames);
    }

    private boolean isFilteredFile() {
        return this.name.startsWith("CVSROOT") || !this.builder.matchesPatterns(this.name);
    }

    private boolean fileExistsInLogPeriod() {
        if (this.revisions.size() > 0) {
            return true;
        }
        try {
            this.builder.getLOC(this.name);
            return true;
        }
        catch (NoLineCountException fileDoesNotExistInTimespan) {
            return false;
        }
    }

    private SortedSet createSymbolicNamesCollection(RevisionData revisionData) {
        TreeSet<SymbolicName> symbolicNames = null;
        Iterator symIt = this.revBySymnames.keySet().iterator();
        while (symIt.hasNext()) {
            String symName = (String)symIt.next();
            String rev = (String)this.revBySymnames.get(symName);
            if (!revisionData.getRevisionNumber().equals(rev)) continue;
            if (symbolicNames == null) {
                symbolicNames = new TreeSet<SymbolicName>();
            }
            logger.fine("adding revision " + this.name + "," + revisionData.getRevisionNumber() + " to symname " + symName);
            symbolicNames.add(this.builder.getSymbolicName(symName));
        }
        return symbolicNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

