/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.util.FileUtils;

public class RepositoryFileManager {
    private static Logger logger;
    private String path;
    private Hashtable revByFilename = new Hashtable();

    public RepositoryFileManager(String pathName) {
        this.path = pathName;
        logger = Logger.getLogger(this.getClass().getName());
    }

    public int getLinesOfCode(String filename) throws NoLineCountException {
        String absoluteName = FileUtils.getAbsoluteName(this.path, filename);
        try {
            FileReader freader = new FileReader(absoluteName);
            BufferedReader reader = new BufferedReader(freader);
            int linecount = this.getLineCount(reader);
            logger.finer("line count for '" + absoluteName + "': " + linecount);
            freader.close();
            return linecount;
        }
        catch (IOException e) {
            throw new NoLineCountException("could not get line count for '" + absoluteName + "': " + e);
        }
    }

    private int getLineCount(BufferedReader reader) throws IOException {
        int linecount = 0;
        while (reader.readLine() != null) {
            ++linecount;
        }
        return linecount;
    }

    /*
     * WARNING - void declaration
     */
    public String getRevision(String filename) throws IOException {
        block5: {
            String string;
            String rev = (String)this.revByFilename.get(filename);
            if (rev != null) {
                return rev;
            }
            String baseDir = FileUtils.getParentDirectoryPath(filename);
            String entriesFilename = baseDir + "CVS" + FileUtils.getDefaultDirSeparator() + "Entries";
            String absoluteName = FileUtils.getAbsoluteName(this.path, entriesFilename);
            BufferedReader in = new BufferedReader(new FileReader(absoluteName));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    StringTokenizer t;
                    void var7_7;
                    if (var7_7.startsWith("D") || (t = new StringTokenizer((String)var7_7, "/")).countTokens() < 2) continue;
                    this.revByFilename.put(baseDir + t.nextToken(), t.nextToken());
                }
                rev = (String)this.revByFilename.get(filename);
                if (rev == null) break block5;
                string = rev;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return string;
        }
        throw new IOException("File " + filename + " has no revision");
    }
}

