/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.CvsRevision;

public class Author
implements Comparable {
    private final String name;
    private final SortedSet revisions = new TreeSet();
    private final SortedSet directories = new TreeSet();

    public Author(String name) {
        this.name = name;
    }

    protected void addRevision(CvsRevision revision) {
        this.revisions.add(revision);
        this.directories.add(revision.getFile().getDirectory());
    }

    public String getName() {
        return this.name;
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public SortedSet getDirectories() {
        return this.directories;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((Author)o).getName());
    }

    public String toString() {
        return this.name + "(" + this.revisions.size() + " revisions)";
    }
}

