/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;

public class CvsContent {
    private final SortedSet files = new TreeSet();
    private final SortedSet authors = new TreeSet();
    private final SortedSet revisions = new TreeSet();
    private Directory root = null;
    private Date firstDate = null;
    private Date lastDate = null;
    private List commits;
    private SortedSet symbolicNames = new TreeSet();

    public void addFile(CvsFile file) {
        this.files.add(file);
        Iterator it = file.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision revision = (CvsRevision)it.next();
            this.revisions.add(revision);
            if (revision.getAuthor() != null) {
                this.authors.add(revision.getAuthor());
            }
            this.adjustStartAndEndDate(revision.getDate());
        }
        if (this.root == null) {
            this.initRoot();
        }
    }

    public void setCommits(List commits) {
        this.commits = commits;
    }

    public List getCommits() {
        return this.commits;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public int getCurrentLOC() {
        int result = 0;
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            CvsFile file = (CvsFile)it.next();
            result += file.getCurrentLinesOfCode();
        }
        return result;
    }

    public SortedSet getFiles() {
        return this.files;
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public SortedSet getDirectories() {
        return this.getRoot().getSubdirectoriesRecursive();
    }

    public Directory getRoot() {
        return this.root;
    }

    public void setSymbolicNames(SortedSet symbolicNames) {
        this.symbolicNames = symbolicNames;
    }

    public SortedSet getSymbolicNames() {
        return this.symbolicNames;
    }

    public String toString() {
        String result = "";
        Iterator it = this.files.iterator();
        CvsFile cf = null;
        while (it.hasNext()) {
            cf = (CvsFile)it.next();
            result = result + cf.toString() + "\n";
        }
        return result;
    }

    public SortedSet getAuthors() {
        return this.authors;
    }

    private void initRoot() {
        if (this.files.isEmpty()) {
            return;
        }
        CvsFile file = (CvsFile)this.files.first();
        Directory dir = file.getDirectory();
        while (!dir.isRoot()) {
            dir = dir.getParent();
        }
        this.root = dir;
    }

    private void adjustStartAndEndDate(Date revisionDate) {
        if (revisionDate == null) {
            return;
        }
        if (this.firstDate == null || this.firstDate.compareTo(revisionDate) > 0) {
            this.firstDate = revisionDate;
        }
        if (this.lastDate == null || this.lastDate.compareTo(revisionDate) < 0) {
            this.lastDate = revisionDate;
        }
    }
}

