/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;

public class CvsFile
implements Comparable {
    private final String filename;
    private final SortedSet revisions = new TreeSet();
    private final Directory directory;
    private final Set authors = new HashSet();

    public CvsFile(String name, Directory directory) {
        this.filename = name;
        this.directory = directory;
        if (directory != null) {
            directory.addFile(this);
        }
    }

    public Set getAuthors() {
        return this.authors;
    }

    public String getFilenameWithPath() {
        return this.filename;
    }

    public String getFilename() {
        int lastDelim = this.filename.lastIndexOf("/");
        return this.filename.substring(lastDelim + 1, this.filename.length());
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public CvsRevision getLatestRevision() {
        return (CvsRevision)this.revisions.last();
    }

    public CvsRevision getInitialRevision() {
        return (CvsRevision)this.revisions.first();
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public int getCurrentLinesOfCode() {
        return this.getLatestRevision().getLines();
    }

    public boolean isDead() {
        return this.getLatestRevision().isDead();
    }

    public boolean hasAuthor(Author author) {
        return this.authors.contains(author);
    }

    public CvsRevision getPreviousRevision(CvsRevision revision) {
        if (!this.revisions.contains(revision)) {
            throw new IllegalArgumentException("revision not containted in file");
        }
        SortedSet<CvsRevision> headSet = this.revisions.headSet(revision);
        if (headSet.isEmpty()) {
            return null;
        }
        return headSet.last();
    }

    public String toString() {
        return this.getFilenameWithPath() + " (" + this.revisions.size() + " revisions)";
    }

    public int compareTo(Object other) {
        return this.filename.compareTo(((CvsFile)other).filename);
    }

    public CvsRevision addInitialRevision(String revisionNumber, Author author, Date date, String comment, int lines, SortedSet symbolicNames) {
        CvsRevision result = new CvsRevision(this, revisionNumber, 1, author, date, comment, lines, lines, 0, symbolicNames);
        this.addRevision(result);
        return result;
    }

    public CvsRevision addChangeRevision(String revisionNumber, Author author, Date date, String comment, int lines, int linesDelta, int replacedLines, SortedSet symbolicNames) {
        CvsRevision result = new CvsRevision(this, revisionNumber, 2, author, date, comment, lines, linesDelta, replacedLines, symbolicNames);
        this.addRevision(result);
        return result;
    }

    public CvsRevision addDeletionRevision(String revisionNumber, Author author, Date date, String comment, int lines, SortedSet symbolicNames) {
        CvsRevision result = new CvsRevision(this, revisionNumber, 3, author, date, comment, 0, -lines, 0, symbolicNames);
        this.addRevision(result);
        return result;
    }

    public CvsRevision addBeginOfLogRevision(Date date, int lines, SortedSet symbolicNames) {
        CvsRevision result = new CvsRevision(this, "0.0", 5, null, date, null, lines, 0, 0, symbolicNames);
        this.addRevision(result);
        return result;
    }

    private void addRevision(CvsRevision revision) {
        this.revisions.add(revision);
        if (revision.getAuthor() != null) {
            this.authors.add(revision.getAuthor());
        }
    }
}

