/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.CvsRevision;

public class SymbolicName
implements Comparable {
    private final String name;
    private final SortedSet revisions = new TreeSet();

    public SymbolicName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void addRevision(CvsRevision rev) {
        this.revisions.add(rev);
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public Date getDate() {
        if (this.revisions.isEmpty()) {
            return null;
        }
        return ((CvsRevision)this.revisions.last()).getDate();
    }

    public int compareTo(Object o) {
        SymbolicName other = (SymbolicName)o;
        if (this.getDate() == null || other.getDate() == null) {
            return this.getName().compareTo(other.getName());
        }
        int dateComp = this.getDate().compareTo(other.getDate());
        return dateComp != 0 ? dateComp : this.getName().compareTo(other.getName());
    }

    public String toString() {
        return this.name + "[" + this.getDate() + "] (" + this.revisions.size() + " revisions)";
    }

    public boolean equals(Object obj) {
        SymbolicName other = (SymbolicName)obj;
        return ("" + this.getDate() + this.getName()).equals("" + other.getDate() + other.getName());
    }

    public int hashCode() {
        return ("" + this.getDate() + this.getName()).hashCode();
    }
}

