/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.HashSet;
import java.util.Set;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class ViewCvsIntegration
implements WebRepositoryIntegration {
    private String baseURL;
    private Set atticFileNames = new HashSet();
    private String postfix;

    public ViewCvsIntegration(String baseURL) {
        int i = baseURL.indexOf("?");
        if (i != -1) {
            this.postfix = baseURL.substring(i + 1);
            baseURL = baseURL.substring(0, i);
        }
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public String getName() {
        return "ViewCVS";
    }

    public String getDirectoryUrl(Directory directory) {
        return this.baseURL + "/" + directory.getPath();
    }

    private String getFileUrl(CvsFile file, String parameter) {
        String filename;
        if (this.isInAttic(file)) {
            String path = file.getDirectory().getPath();
            filename = "/" + path + "Attic/" + file.getFilename();
        } else {
            filename = "/" + file.getFilenameWithPath();
        }
        String append = parameter;
        if (this.postfix != null) {
            append = append + (append.length() > 0 ? "&" + this.postfix : "?" + this.postfix);
        }
        return this.baseURL + filename + append;
    }

    public String getFileHistoryUrl(CvsFile file) {
        return this.getFileUrl(file, "");
    }

    public String getFileViewUrl(CvsFile file) {
        return this.getFileUrl(file, "?rev=HEAD&content-type=text/vnd.viewcvs-markup");
    }

    public String getFileViewUrl(CvsRevision revision) {
        return this.getFileUrl(revision.getFile(), "?rev=" + revision.getRevisionNumber() + "&content-type=text/vnd.viewcvs-markup");
    }

    public String getDiffUrl(CvsRevision oldRevision, CvsRevision newRevision) {
        if (!oldRevision.getFile().equals(newRevision.getFile())) {
            throw new IllegalArgumentException("revisions must be of the same file");
        }
        return this.getFileUrl(oldRevision.getFile(), "?r1=" + oldRevision.getRevisionNumber() + "&r2=" + newRevision.getRevisionNumber());
    }

    public void setAtticFileNames(Set atticFileNames) {
        this.atticFileNames = atticFileNames;
    }

    private boolean isInAttic(CvsFile file) {
        return this.atticFileNames.contains(file.getFilenameWithPath());
    }
}

