/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    /*
     * WARNING - void declaration
     */
    public static void copyFile(String inputName, String destination) throws FileNotFoundException, IOException {
        int c;
        File input = new File(inputName);
        File outputFile = new File(destination);
        FileReader in = new FileReader(input);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            void var6_6;
            out.write((int)var6_6);
        }
        in.close();
        out.close();
    }

    public static void copyFile(InputStream in, File out) throws FileNotFoundException, IOException {
        InputStream fis = in;
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static String getFilenameWithoutPath(String filename) {
        File f = new File(filename);
        return f.getName();
    }

    public static String getDirSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getDefaultDirSeparator() {
        return File.separator;
    }

    public static String getPathWithoutEndingSlash(String path) {
        if (path.endsWith(FileUtils.getDefaultDirSeparator())) {
            int pos = path.lastIndexOf(FileUtils.getDefaultDirSeparator());
            return path.substring(0, pos);
        }
        return path;
    }

    public static String getAbsoluteName(String path, String filename) {
        return path + FileUtils.getDirSeparator() + filename;
    }

    public static String getDirectoryName(String path) {
        if ("".equals(path)) {
            throw new IllegalArgumentException("can't get directory name for root");
        }
        String pathWithoutLastSlash = path.substring(0, path.length() - 1);
        int lastSlash = pathWithoutLastSlash.lastIndexOf(47);
        if (lastSlash == -1) {
            return pathWithoutLastSlash;
        }
        return pathWithoutLastSlash.substring(lastSlash + 1);
    }

    public static String getParentDirectoryPath(String path) {
        if ("".equals(path)) {
            throw new IllegalArgumentException("can't get directory name for root");
        }
        String pathWithoutLastSlash = path.substring(0, path.length() - 1);
        int lastSlash = pathWithoutLastSlash.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return pathWithoutLastSlash.substring(0, lastSlash + 1);
    }
}

