/*
 * Decompiled with CFR 0.152.
 */
package stream.alwaysbecrafting.flare;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import stream.alwaysbecrafting.flare.GameEngine;

public class Entity {
    private final Map<Class<?>, Object> COMPONENTS = new HashMap();
    private GameEngine engine;

    public Entity(Object ... components) {
        Arrays.asList(components).forEach(component -> this.COMPONENTS.put(component.getClass(), component));
    }

    public void setEngine(GameEngine engine) {
        this.engine = engine;
    }

    public GameEngine getEngine() {
        return this.engine;
    }

    Collection<Class<?>> getComponentTypes() {
        return this.COMPONENTS.keySet();
    }

    Collection getComponents() {
        return this.COMPONENTS.values();
    }

    public boolean add(Object component) {
        return this.COMPONENTS.putIfAbsent(component.getClass(), component) == null;
    }

    public <T> T get(Class<T> componentType) {
        return (T)this.COMPONENTS.get(componentType);
    }

    public boolean remove(Class<?> componentType) {
        return this.COMPONENTS.remove(componentType) != null;
    }

    public boolean hasAll(Collection<Class<?>> componentTypes) {
        return this.COMPONENTS.keySet().containsAll(componentTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasAny(Collection<Class<?>> componentTypes) {
        if (componentTypes.isEmpty()) return true;
        if (!this.COMPONENTS.keySet().stream().anyMatch(componentTypes::contains)) return false;
        return true;
    }

    public boolean hasNone(Collection<Class<?>> componentTypes) {
        return this.COMPONENTS.keySet().stream().noneMatch(componentTypes::contains);
    }
}

