/*
 * Decompiled with CFR 0.152.
 */
package stream.alwaysbecrafting.flare;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import stream.alwaysbecrafting.flare.Entity;
import stream.alwaysbecrafting.flare.GameEngine;
import stream.alwaysbecrafting.flare.GameSystem;

public abstract class EntitySystem
extends GameSystem {
    private Set<Class<?>> requireAllTypes = new LinkedHashSet();
    private Set<Class<?>> requireOneTypes = new LinkedHashSet();
    private Set<Class<?>> forbidTypes = new LinkedHashSet();
    private boolean onUpdateCalled = false;

    @Override
    public void onUpdate(GameEngine engine, float deltaTime) {
        this.onUpdateCalled = true;
        engine.ENTITIES.stream().filter(entity -> entity.hasAll(this.requireAllTypes)).filter(entity -> entity.hasAny(this.requireOneTypes)).filter(entity -> entity.hasNone(this.forbidTypes)).forEach(entity -> this.onHandleEntity((Entity)entity, deltaTime));
    }

    protected void requireAll(Class<?> ... componentTypes) {
        Collections.addAll(this.requireAllTypes, componentTypes);
    }

    protected void requireOne(Class<?> ... componentTypes) {
        Collections.addAll(this.requireOneTypes, componentTypes);
    }

    protected void forbid(Class<?> ... componentTypes) {
        Collections.addAll(this.forbidTypes, componentTypes);
    }

    protected abstract void onHandleEntity(Entity var1, float var2);

    @Override
    void update(GameEngine engine, float deltaTime) {
        this.onUpdateCalled = false;
        super.update(engine, deltaTime);
        if (!this.onUpdateCalled) {
            throw new IllegalStateException("Need to call super.onUpdate() to handle entities in an EntitySystem");
        }
    }
}

