/*
 * Decompiled with CFR 0.152.
 */
package stream.alwaysbecrafting.flare;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import stream.alwaysbecrafting.flare.Entity;
import stream.alwaysbecrafting.flare.GameSystem;

public class GameEngine {
    final Set<Entity> ENTITIES = new HashSet<Entity>();
    private final SortedMap<GameSystem, Class<? extends GameSystem>> SYSTEMS = new ConcurrentSkipListMap<GameSystem, Class<? extends GameSystem>>();
    private boolean isPaused = false;

    public void add(GameSystem system) {
        if (this.SYSTEMS.containsValue(system.getClass())) {
            throw new IllegalStateException(system.getClass().getName() + " already exists in engine");
        }
        if (system.priority == Integer.MIN_VALUE) {
            system.priority = this.SYSTEMS.isEmpty() ? 0 : this.SYSTEMS.lastKey().priority + 1;
        }
        this.SYSTEMS.put(system, system.getClass());
        system.onStart(this);
        system.resume();
    }

    public void add(GameSystem system, int priority) {
        system.priority = priority;
        this.add(system);
    }

    public void update(float deltaTime) {
        if (this.isPaused) {
            return;
        }
        this.SYSTEMS.keySet().forEach(system -> system.update(this, deltaTime));
    }

    public void remove(GameSystem system) {
        if (this.SYSTEMS.remove(system, system.getClass())) {
            system.pause();
            system.onStop(this);
        }
    }

    public void remove(Class<? extends GameSystem> systemType) {
        this.SYSTEMS.entrySet().stream().filter(entry -> entry.getValue() == systemType).map(Map.Entry::getKey).forEach(this::remove);
    }

    public void add(Entity entity) {
        this.ENTITIES.add(entity);
    }

    public void remove(Entity entity) {
        this.ENTITIES.remove(entity);
    }

    public void pause() {
        if (!this.isPaused) {
            this.SYSTEMS.keySet().forEach(system -> {
                if (!system.isPaused) {
                    system.onPause();
                }
            });
        }
        this.isPaused = true;
    }

    public void resume() {
        if (this.isPaused) {
            this.SYSTEMS.keySet().forEach(system -> {
                if (!system.isPaused) {
                    system.onResume();
                }
            });
        }
        this.isPaused = false;
    }
}

